(*============================================================================*)
(*== UE Conception de Langages -- Octobre 2006                              ==*)
(*============================================================================*)
(*== Fichier: lsrc_ast.ml                                                   ==*)
(*== ---------------------------------------------------------------------- ==*)
(*== Dfinition du type d'arbre de syntaxe abstraite du langage source      ==*)
(*== et traitements auxiliaires.                                            ==*)
(*==                                                                        ==*)
(*============================================================================*)    
type prog =
    ASTProg of (dec list) * (stat list)

and dec =
    ASTCst of string * exp
  | ASTVar of string
  | ASTFun of string * (string list) * exp
  | ASTFunRec of string * (string list) * exp
  | ASTProc of string * (string list) * stat
  | ASTProcRec of string * (string list) * stat

and stat =
    ASTSet of string * exp
  | ASTCall of string * (exp list)
  | ASTCallRec of string * (exp list)
  | ASTBloc of (dec list) * (stat list)
  | ASTLoop of stat
  | ASTLoopW of exp * stat
  | ASTLoopU of exp * stat
  | ASTLoopF of string * rng * stat
  | ASTBreak
  | ASTIf1 of exp * stat
  | ASTIf2 of exp * stat *stat
  | ASTTry of stat * ((string * stat) list)
  | ASTRaise of string

and exp =
    ASTNum of int
  | ASTStr of string
  | ASTId of string
  | ASTApp of string * (exp list)
  | ASTAppRec of string * (exp list)

and rng =
    ASTNrng of exp * exp
  | ASTLrng of exp

(* == Explicitation des appels rcursifs                                      *)
(* -- Fonctions                                                               *)
let rec fun_rec f e =
  match e with
    ASTApp(f',es) ->
      if (f=f') then
        ASTAppRec(f,List.map (fun_rec f) es)
      else
        ASTApp(f', List.map (fun_rec f) es)
  | _ -> e

(* -- Procdures                                                              *)
let rec proc_rec p s =
  match s with
    ASTCall(p',es) ->
      if (p=p') then ASTCallRec(p,es) else ASTCall(p',es)
  | ASTBloc(ds, ss) -> ASTBloc(ds, List.map (proc_rec p) ss)
  | ASTLoop s -> ASTLoop ((proc_rec p) s)
  | ASTLoopW(e,s) -> ASTLoopW(e, proc_rec p s)
  | ASTLoopU(e,s) -> ASTLoopU(e, proc_rec p s)
  | ASTLoopF(x,r,s) -> ASTLoopF(x, r, proc_rec p s)
  | ASTIf1(e,s) -> ASTIf1(e, proc_rec p s)
  | ASTIf2(e,s1,s2) -> ASTIf2(e, proc_rec p s1, (proc_rec p) s2)
  | ASTTry(s, cs) -> ASTTry(proc_rec p s,
                            List.map (fun (x,s) -> (x, proc_rec p s)) cs)
  | _ -> s
