(*============================================================================*)
(*== UE Conception de Langages -- Octobre 2006                              ==*)
(*============================================================================*)
(*== Fichier: lsrc_lexer.mll                                                ==*)
(*== ---------------------------------------------------------------------- ==*)
(*== Analyse lexicale du langage source.                                    ==*)
(*==                                                                        ==*)
(*==                                                                        ==*)
(*============================================================================*)
{
 open Lsrc_parser
 let string_cont s =
   let len = String.length s in
     if len < 3 then
       ""
     else
       String.sub s 1 (len-2)
}

rule token = parse
 [' ' '\t' '\n'] 	{token lexbuf}
|eof                    {END}
|','                    {COM}
|':'                    {COL}
|';'                    {SEMCOL}
|'='			{EQ}
|'('			{LPAR}
|')'			{RPAR}
|'['                    {LSQRB}
|']'                    {RSQRB}
|'{'                    {LCURB}
|'}'                    {RCURB}
|":="                   {SET}
|".."                   {DDOT}
|"Cst"                  {CST}
|"Var"                  {VAR}
|"Fun"                  {FUN}
|"FunRec"               {FUNREC}
|"Proc"                 {PROC}
|"ProcRec"              {PROCREC}
|"If"                   {IF}
|"IF"                   {IFF}
|"Else"                 {ELSE}
|"Loop"                 {LOOP}
|"While"                {WHILE}
|"Until"                {UNTIL}
|"For"                  {FOR}
|"In"                   {IN}
|"Break"                {BREAK}
|"Try"                  {TRY}
|"With"                 {WITH}
|"Do"                   {DO}
|"Raise"                {RAISE}
|(['a'-'z''A'-'Z'])(['a'-'z''A'-'Z''0'-'9''?'])* 
			{IDENT(Lexing.lexeme lexbuf)}
|('-'?)['0'-'9']+       {NUM(int_of_string (Lexing.lexeme lexbuf))}
|'"'([^'"']|"\\\"")*'"' {STR(string_cont (Lexing.lexeme lexbuf))}

