%{
(*============================================================================*)
(*== UE Conception de Langages -- Octobre 2006                              ==*)
(*============================================================================*)
(*== Fichier: lsrc_parser.mly                                               ==*)
(*== ---------------------------------------------------------------------- ==*)
(*== Analyse syntaxique du langage source.                                  ==*)
(*==  Engendre l'arbre de syntaxe abstraite du source analys.              ==*)
(*==  Rgle d'entre: 'prog'                                                 ==*)
(*============================================================================*)
open Lsrc_ast

%}

%token END
%token SEMCOL COM DDOT COL
%token LPAR RPAR LCURB RCURB LSQRB RSQRB
%token EQ SET
%token CST VAR FUN PROC FUNREC PROCREC
%token IF ELSE IFF
%token LOOP WHILE UNTIL FOR IN
%token BREAK
%token TRY WITH DO
%token RAISE
%token <int> NUM
%token <string> STR
%token <string> IDENT
%start prog
%type <Lsrc_ast.prog> prog
%%

prog :
  stats END              {ASTProg([],$1)}
| decs stats END         {ASTProg($1,$2)}
;

dec :
 CST IDENT EQ exp SEMCOL      
                        {ASTCst($2,$4)}
|VAR IDENT SEMCOL       {ASTVar($2)}
|FUN LPAR IDENT ids RPAR EQ exp SEMCOL
                        {ASTFun($3,$4,$7)}
|PROC IDENT LPAR idsc RPAR EQ stat 
                        {ASTProc($2,$4,$7)}
|FUNREC LPAR IDENT ids RPAR EQ exp SEMCOL
                        {ASTFunRec($3,$4,$7)}
|PROCREC IDENT LPAR idsc RPAR EQ stat 
                        {ASTProcRec($2,$4,$7)}
;

decs :
  dec                   {[$1]}
| dec decs              {$1::$2}
;

stat :
 IDENT SET exp SEMCOL   {ASTSet($1,$3)}
|IDENT exp SEMCOL       {ASTCall($1,[$2])}
|IDENT LPAR expsc RPAR SEMCOL
                        {ASTCall($1,$3)}
|LCURB stats RCURB SEMCOL
                        {ASTBloc([],$2)}
|LCURB decs stats RCURB SEMCOL
                        {ASTBloc($2,$3)}
|LOOP stat              {ASTLoop($2)}
|LOOP WHILE exp stat    {ASTLoopW($3,$4)}
|LOOP UNTIL exp stat    {ASTLoopU($3,$4)}
|LOOP FOR LPAR IDENT IN rng RPAR stat
                        {ASTLoopF($4,$6,$8)}
|BREAK SEMCOL           {ASTBreak}
|IF exp stat            {ASTIf1($2,$3)}
|IF exp stat ELSE stat  {ASTIf2($2,$3,$5)}
|TRY stat WITH catches  {ASTTry($2,$4)}
|RAISE IDENT SEMCOL     {ASTRaise($2)}
;

catches :
  IDENT DO stat         {[$1, $3]}
| IDENT DO stat ELSE catches
                        {($1,$3)::$5}
;

stats :
 stat                   {[$1]}
|stat stats             {$1::$2}
;

expsc :
 exp                    {[$1]}
|exp COM expsc          {$1::$3}
;

idsc :
 IDENT                  {[$1]}
|IDENT COM idsc         {$1::$3}
;

exp :
  NUM                   {ASTNum $1}
| STR                   {ASTStr $1}
| IDENT                 {ASTId $1}
| LPAR IFF exp exp exp RPAR
                        {ASTApp("IF",[$3;$4;$5])}
| LPAR IDENT exps RPAR  {ASTApp($2,$3)}
;

rng :
 LSQRB exp DDOT exp RSQRB 
                        {ASTNrng($2,$4)}
|exp                    {ASTLrng($1)}

exps :
 exp                    {[$1]}
|exp exps               {$1::$2}
;

ids :
 IDENT                  {[$1]}
|IDENT ids              {$1::$2}
;

