(*============================================================================*)
(*== UE Conception de Langages -- Octobre 2006                              ==*)
(*============================================================================*)
(*== Fichier: sem.ml                                                        ==*)
(*== ---------------------------------------------------------------------- ==*)
(*== Programme principal.                                                   ==*)
(*== Transcription smantique et valuation du programme source contenu      ==*)
(*== dans le fichier dont le nom est pass en argument sur le ligne de      ==*)
(*== commande.                                                              ==*)
(*============================================================================*)
open Lb_utils;;

(*== Produit l'arbre de syntaxe abstraite du source contenu dans le fichier   *)
(*  de nom 'f'.                                                               *)
(*  Inutilis ici.                                                            *)
let ast_prog f =
 let ic = open_in f in
 let lexbuf = Lexing.from_channel ic in
   Lsrc_parser.prog Lsrc_lexer.token lexbuf

(*== Produit le lambda terme xe abstraite du source contenu dans le fichier   *)
(*  de nom 'f'.                                                               *)
(*  Inutilis ici.                                                            *)
let sem_prog f =
 let ic = open_in f in
 let lexbuf = Lexing.from_channel ic in
 let ast = Lsrc_parser.prog Lsrc_lexer.token lexbuf in
   Lsrc_sem.semProg ast sg0 mu0

(*== Affiche le lambda terme xe abstraite du source contenu dans le fichier   *)
(*  de nom 'f'.                                                               *)
(*  Inutilis ici.                                                            *)
let print_sem_prog f =
 output_string stdout (Lb_type.to_string (sem_prog f))

(*== Produit l'arbre de syntaxe abstraite du source donn dans le canal       *)
(*  d'entre 'ic'.                                                            *)
let parse_prog ic =
  let lexbuf = Lexing.from_channel ic in
    try
      Lsrc_parser.prog Lsrc_lexer.token lexbuf 
    with
	Parsing.Parse_error -> (
	    Printf.fprintf stderr "Erreur syntaxique autour du caractre %d\n"
	                          (lexbuf.Lexing.lex_curr_pos);
	    raise Parsing.Parse_error)
	
(*== Fonction principale: traite le fichier de nom 'f'.                       *)
let eval_prog f =
 let ic = open_in f in
 let ast = parse_prog ic in
 let lb = Lsrc_sem.semProg ast sg0 mu0 in
 let tes = ref (Lb_type.NIL, Lb_eval.Nil, []) in
   reset_addr();
   tes := Lb_eval.eval lb lb_env0 []
;;

(*== Programme principal ...                                                  *)
if Array.length(Sys.argv) < 2 then
  output_string stderr "Usage: sem <source_file>\n"
else
  eval_prog (Sys.argv.(1))

