exception Bad_data

let is_comment line =
  (line.[0] = '-') && (line.[1]='-')

let line_to_data line =
  let datas = Xstring.split ' ' line in
  let split_data str =
    try
      ((if str.[0]='0' then false 
	else if str.[0]='1' then true 
	else raise Bad_data),
       int_of_string (Xstring.suffix str 1))
    with
	_ -> raise Bad_data
  in
    List.map split_data datas
;;

if (Array.length Sys.argv < 2) then
  Printf.printf"usage: %s <filename>\n" Sys.argv.(0)
else
  let ic = open_in Sys.argv.(1) in
  let oc = open_out "test.res" in
    try
      while true do
	let line = input_line ic in
	  if not (is_comment line) then (
	    match (line_to_data line) with 
		[vn1; vn2; vn3; _] -> (
		  let v,n = Voteur.voteur vn1 vn2 vn3 in
		    Printf.fprintf oc "%s %d%d\n" line (if v then 1 else 0) n
		)
	      | _ -> (
		  close_in ic;
		  close_out oc;
		  raise Bad_data
		)
	  )
	  done
    with
	End_of_file -> (
	  close_in ic;
	  close_out oc
	)

    
    
