let prefix s n =
 try String.sub s 0 n
 with Invalid_argument("String.sub") -> s
 
let suffix s i =
 try String.sub s i ((String.length s)-i)
 with Invalid_argument("String.sub") -> ""
 
let rec split c s =
 try
  let i = String.index s c in
  let s1, s2 = prefix s i, suffix s (i+1) in
   s1::(split c s2)
 with
  Not_found -> [s]
 
let unsplit c = String.concat (Char.escaped c)
