open Printf
open Array

type sensor = {mutable value:int; mutable validity:bool}
  

let init_sensor s =
  match s with
    | (x,y) -> {value = x; validity = y}
;;

let usage = "./Voteur int bool int bool int bool";;

let string_of_sensor s =
  printf "Value: %d; Validity: %B\n" s.value s.validity;; 

let int_of_bool b =
  match b with
    | true -> 1
    | false -> 0

let voteur s1 s2 s3 va ba= 
  if s1.value > 1023 || s2.value > 1023 || s3.value > 1023 then failwith "une value lue par le capteur superieur a 1023"
  else if s1.value < 0 || s2.value < 0 || s3.value < 0 then failwith "une valeur lue par le capteur negative"
  else
    let coherence s1 s2 res = 
      res.value <- (s1.value + s2.value)/2;
      if s1.value = s2.value then res.validity <- true
      else if (s1.value >= s2.value - 5 && s1.value <= s2.value + 5) || (s2.value >= s1.value - 5 && s2.value <= s1.value + 5) then 
	res.validity <- true
      else res.validity <- false
    in let opt s1 res =
	 if s1.value >= 70 && s1.value <= 950 then
	   begin
	     res.value <- s1.value;
	     res.validity <- true
	   end
	 else
	   res.validity <- false
       in let res = {value = 0; validity = false} in
	  if s1.validity = true && s2.validity = true && s3.validity = true then 
	    begin
	      res.value <- (s1.value + s2.value + s3.value)/3; 
	      res.validity <- true
	    end
	  else if s1.validity = false && s2.validity = false && s3.validity = false then res.validity <- false
	  else if s1.validity = true && s2.validity = true then (coherence s1 s2 res)
	  else if s1.validity = true && s3.validity = true then (coherence s1 s3 res)
	  else if s2.validity = true && s3.validity = true then (coherence s2 s3 res)
	  else if s1.validity = true then opt s1 res
	  else if s2.validity = true then opt s2 res
	  else opt s3 res;
	  printf "%d %d %d %d %d %d %s %s %d %d\n" s1.value (int_of_bool s1.validity) s2.value (int_of_bool s2.validity) s3.value (int_of_bool s3.validity) va ba res.value (int_of_bool res.validity)
	    
	    
let bool_of_int_string m =
  let n = (int_of_string m) in
  match n with
    | 0 -> false
    | 1 -> true
    | _ -> failwith "mauvaise"

let main args =
  let len = (Array.length args) in
  try
    if len <= 1 then 
      begin
	printf "%s\t" usage;
	failwith "Aucune option saisie"
      end
    else if len = 8 then
      try
	let s1 = (init_sensor ((int_of_string (Array.get args 0)),(bool_of_int_string (Array.get args 1)))) 
	and s2 = (init_sensor ((int_of_string (Array.get args 2)),(bool_of_int_string (Array.get args 3)))) 
	and s3 = (init_sensor ((int_of_string (Array.get args 4)),(bool_of_int_string (Array.get args 5)))) 
	in
	(voteur s1 s2 s3 (Array.get args 6) (Array.get args 7))
      with
	| Failure _ -> printf "Erreur type des arguments: veuillez saisir des valeurs entières >0 et < 1024. Ex: 100\n"
	| Invalid_argument _ -> printf "Mauvaise representation des booleens\n"
    else 
      begin
	printf "%s\t" usage;
	failwith "Saisie incorrect";
      end
  with
    | Failure msg ->  printf "%s\n" msg
;;

let parse_line input_name = 
  let in_chan = open_in input_name in
  let out_chan = open_out "sortie" in
  let size = in_channel_length in_chan in
  let cur = ref 0 in
  let rec split_char sep str =
    try
      let i = String.index str sep in
      String.sub str 0 i ::
	split_char sep (String.sub str (i+1) (String.length str - i - 1))
    with Not_found ->
      [str]
  in
  let buf = ref "1" in
  try
    while (!cur < size) do
      let line = input_line in_chan in
      let list = (split_char ' ' line) in
      main (Array.of_list list);
      cur := !cur + (String.length line);
    done;
    (output_string out_chan (!buf));
    close_out out_chan;
    close_in in_chan
  with End_of_file -> printf "End of file\n"
;;

parse_line "input";;
