﻿using Voteur;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;

namespace TestProject
{
    
    
    /// <summary>
    ///Classe de test pour CapteurTest, destinée à contenir tous
    ///les tests unitaires CapteurTest
    ///</summary>
    [TestClass()]
    public class CapteurTest {


        private TestContext testContextInstance;

        /// <summary>
        ///Obtient ou définit le contexte de test qui fournit
        ///des informations sur la série de tests active ainsi que ses fonctionnalités.
        ///</summary>
        public TestContext TestContext {
            get {
                return testContextInstance;
            }
            set {
                testContextInstance = value;
            }
        }

        #region Attributs de tests supplémentaires
        // 
        //Vous pouvez utiliser les attributs supplémentaires suivants lorsque vous écrivez vos tests :
        //
        //Utilisez ClassInitialize pour exécuter du code avant d'exécuter le premier test dans la classe
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //Utilisez ClassCleanup pour exécuter du code après que tous les tests ont été exécutés dans une classe
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //Utilisez TestInitialize pour exécuter du code avant d'exécuter chaque test
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //Utilisez TestCleanup pour exécuter du code après que chaque test a été exécuté
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        ///Test pour Voteur
        ///</summary>
        [TestMethod()]
        public void VoteurTest() {
            Capteur capteur1;
            Capteur capteur2;
            Capteur capteur3;
            Capteur expected;
            Capteur actual;


            capteur1 = new Capteur( true, 150 );
            capteur2 = new Capteur( true, 100 );
            capteur3 = new Capteur( true, 350 );

            actual = Capteur.Voteur( capteur1, capteur2, capteur3 );

            expected = new Capteur( true, 200 );

            Assert.AreEqual( expected, actual );

            capteur1 = new Capteur( false, 150 );
            capteur2 = new Capteur( true, 100 );
            capteur3 = new Capteur( true, 102 );

            actual = Capteur.Voteur( capteur1, capteur2, capteur3 );

            expected = new Capteur( true, 101 );

            Assert.AreEqual( expected, actual );

            capteur1 = new Capteur( true, 1023 );
            capteur2 = new Capteur( true, 1023 );
            capteur3 = new Capteur( false, 102 );

            actual = Capteur.Voteur( capteur1, capteur2, capteur3 );

            expected = new Capteur( true, 1023 );

            Assert.AreEqual( expected, actual );

            capteur1 = new Capteur( false, 150 );
            capteur2 = new Capteur( true, 100 );
            capteur3 = new Capteur( true, 120 );

            actual = Capteur.Voteur( capteur1, capteur2, capteur3 );

            Assert.IsFalse( actual.estValide() );

            capteur1 = new Capteur( false, 150 );
            capteur2 = new Capteur( false, 100 );
            capteur3 = new Capteur( true, 70 );

            actual = Capteur.Voteur( capteur1, capteur2, capteur3 );

            expected = new Capteur( true, 70 );

            Assert.AreEqual( expected, actual );

            capteur1 = new Capteur( false, 150 );
            capteur2 = new Capteur( false, 100 );
            capteur3 = new Capteur( true, 950 );

            actual = Capteur.Voteur( capteur1, capteur2, capteur3 );

            expected = new Capteur( true, 950 );

            Assert.AreEqual( expected, actual );

            capteur1 = new Capteur( false, 150 );
            capteur2 = new Capteur( false, 100 );
            capteur3 = new Capteur( true, 69 );

            actual = Capteur.Voteur( capteur1, capteur2, capteur3 );

            Assert.IsFalse( actual.estValide() );

            capteur1 = new Capteur( false, 150 );
            capteur2 = new Capteur( false, 100 );
            capteur3 = new Capteur( true, 951 );

            actual = Capteur.Voteur( capteur1, capteur2, capteur3 );

            Assert.IsFalse( actual.estValide() );   

            capteur1 = new Capteur( false, 150 );
            capteur2 = new Capteur( false, 100 );
            capteur3 = new Capteur( false, 69 );

            actual = Capteur.Voteur( capteur1, capteur2, capteur3 );

            Assert.IsFalse( actual.estValide() );
        }
    }
}
