﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Voteur  {
    public class Capteur {
        private int valeur;
        private int validite;

        public Capteur(int validite,int valeur){
            this.valeur = valeur;
            this.validite = validite;
        }

        public Capteur( bool validite, int valeur ) {
            this.valeur = valeur;
            this.validite = validite?1:0;//1 == vrai
        }

        public int Valeur{
            get{
                return valeur;
            }
        }

        public int Validite{
            get{
                return validite;
            }
        }

        public bool estValide(){
            return validite==1;
        }

        public static Capteur Voteur(Capteur capteur1,Capteur capteur2, Capteur capteur3){
            int nbCapteurValide = capteur1.Validite + capteur2.Validite + capteur3.Validite;
            int sommeValide = (capteur1.Valeur*capteur1.Validite + capteur2.Valeur*capteur2.Validite + capteur3.Valeur*capteur3.Validite);

            if (nbCapteurValide == 3) {
                return new Capteur( true, sommeValide / 3 );
            } else if (nbCapteurValide == 2) {
                Capteur fstCapteurValide =  capteur1.estValide()?capteur1:capteur2 ;

                if( (sommeValide-2*fstCapteurValide.Valeur < 5) &&  (sommeValide-2*fstCapteurValide.Valeur > -5) ){
                    return new Capteur( true, sommeValide / 2 );
                }else{
                    return new Capteur( false, 0 );
                }
            }else if (nbCapteurValide == 1){
                if( (sommeValide >= 70) && (sommeValide <= 950) ){
                    return new Capteur( true, sommeValide );
                }else{
                    return new Capteur( false, sommeValide );
                }
            }
            
            return new Capteur( false, 0 );;
        }

        public override bool  Equals(Object o){
            if(! (o is Capteur))
                return false;

            Capteur c = o as Capteur;

            return (this.Validite == c.Validite) && (this.Valeur == c.Valeur);
        }

    }
}
