/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Capteur;
import core.Voteur;
import coreException.InvalidCapteur;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RunVoteur {
    public static void main(String[] args) {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        ArrayList<Capteur> capteurList = new ArrayList<Capteur>();
        Pattern inputP = Pattern.compile("([01])([0-9]+)");
        try {
            String line;
            while ((line = stdin.readLine()) != null && line.length() != 0) {
                Matcher matcher = inputP.matcher(line);
                if (!matcher.matches()) {
                    System.out.println("ERROR");
                    System.exit(-1);
                }
                boolean isValid = false;
                if (matcher.group(1).equals("1")) {
                    isValid = true;
                }
                capteurList.add(new Capteur(Short.parseShort(matcher.group(2)), isValid));
                if (capteurList.size() == 3) break;
            }
            if (capteurList.size() != 3) {
                System.out.println("ERROR");
                System.exit(-1);
            }
            Capteur c1 = (Capteur)capteurList.get(0);
            Capteur c2 = (Capteur)capteurList.get(1);
            Capteur c3 = (Capteur)capteurList.get(2);
            Voteur v = new Voteur(c1, c2, c3);
            double voteurValue = v.vote();
            StringBuilder sb = new StringBuilder();
            sb.append(c1.toString());
            sb.append(" - ");
            sb.append(c2.toString());
            sb.append(" - ");
            sb.append(c3.toString());
            sb.append(" == ");
            sb.append((int)voteurValue);
            sb.append(" ");
            sb.append(true);
            System.out.println(sb);
        }
        catch (IOException e) {
            System.err.println("Error input stdin");
        }
        catch (InvalidCapteur inv) {
            Capteur c1 = (Capteur)capteurList.get(0);
            Capteur c2 = (Capteur)capteurList.get(1);
            Capteur c3 = (Capteur)capteurList.get(2);
            StringBuilder sb = new StringBuilder();
            sb.append(c1.toString());
            sb.append(" - ");
            sb.append(c2.toString());
            sb.append(" - ");
            sb.append(c3.toString());
            sb.append(" == ");
            sb.append(0);
            sb.append(" ");
            sb.append(false);
            System.out.println(sb);
        }
        catch (Exception e) {
            Capteur c1 = (Capteur)capteurList.get(0);
            Capteur c2 = (Capteur)capteurList.get(1);
            Capteur c3 = (Capteur)capteurList.get(2);
            StringBuilder sb = new StringBuilder();
            sb.append(c1.toString());
            sb.append(" - ");
            sb.append(c2.toString());
            sb.append(" - ");
            sb.append(c3.toString());
            sb.append(" == ");
            sb.append(0);
            sb.append(" ");
            sb.append("ERROR");
            System.out.println(sb);
        }
        System.exit(0);
    }
}

