/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Capteur;
import coreException.InvalidCapteur;

public class Voteur {
    private Capteur c1;
    private Capteur c2;
    private Capteur c3;

    public Voteur(Capteur c1, Capteur c2, Capteur c3) {
        this.setC1(c1);
        this.setC2(c2);
        this.setC3(c3);
    }

    public double vote() throws InvalidCapteur {
        boolean c1Valid = this.c1.isValid();
        boolean c2Valid = this.c2.isValid();
        boolean c3Valid = this.c3.isValid();
        short c1Val = this.c1.getVal();
        short c2Val = this.c2.getVal();
        short c3Val = this.c3.getVal();
        if (c1Valid && c2Valid && c3Valid) {
            return (c1Val + c2Val + c3Val) / 3;
        }
        if (c1Valid && c2Valid) {
            if (this.isTolerant(this.c1, this.c2)) {
                return (c1Val + c2Val) / 2;
            }
            throw new InvalidCapteur("C1 and C2 incoherent");
        }
        if (c1Valid && c3Valid) {
            if (this.isTolerant(this.c1, this.c3)) {
                return (c1Val + c3Val) / 2;
            }
            throw new InvalidCapteur("C1 and C3 incoherent");
        }
        if (c2Valid && c3Valid) {
            if (this.isTolerant(this.c2, this.c3)) {
                return (c1Val + c2Val) / 2;
            }
            throw new InvalidCapteur("C2 and C3 incoherent");
        }
        if (c1Valid) {
            if (c1Val >= 70 && c1Val <= 950) {
                return c1Val;
            }
            throw new InvalidCapteur("C1 invalid");
        }
        if (c2Valid) {
            if (c2Val >= 70 && c2Val <= 950) {
                return c2Val;
            }
            throw new InvalidCapteur("C2 invalid");
        }
        if (c3Valid) {
            if (c3Val >= 70 && c3Val <= 950) {
                return c3Val;
            }
            throw new InvalidCapteur("C3 invalid");
        }
        throw new InvalidCapteur("Validit\u00e9 incorrect");
    }

    private boolean isTolerant(Capteur c1, Capteur c2) {
        return Math.abs(c1.getVal() - c2.getVal()) <= 5;
    }

    public Capteur getC1() {
        return this.c1;
    }

    public void setC1(Capteur c1) {
        this.c1 = c1;
    }

    public Capteur getC2() {
        return this.c2;
    }

    public void setC2(Capteur c2) {
        this.c2 = c2;
    }

    public Capteur getC3() {
        return this.c3;
    }

    public void setC3(Capteur c3) {
        this.c3 = c3;
    }
}

