package fr.upmc.test.voteurtest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import fr.upmc.test.voteur.Voteur;

public class Tests {
	public static void main(String[] arg) {
		File inputFile = new File("./testInputFile");
		File outputFile = new File("./testOutputFile");
		Voteur v = new Voteur();
		System.out.println("Testing...");
		try {
			BufferedReader input = new BufferedReader(new FileReader(inputFile));
			FileWriter output = new FileWriter(outputFile);
			String testNum = "";
			while((testNum = input.readLine()) != null) {
				//test number
				output.write(testNum+"\n");	
				//test description
				String description = input.readLine();
				output.write("Description : " + description+"\n");
				//inputs
				String capteur1 = input.readLine();		
				String capteur2 = input.readLine();
				String capteur3 = input.readLine();
				output.write("Entres : " + capteur1 + " " + capteur2 + " " + capteur3 +"\n");
				//result attendu
				String sortieAttendu = input.readLine();
				output.write("Sortie Attendu : " + sortieAttendu + "\n");
				//result obtenu
				String sortieObtenu = v.voteur(capteur1, capteur2, capteur3);
				output.write("Sortie Obtenu : " + sortieObtenu + "\n");
				//statut
				if(sortieAttendu.endsWith(sortieObtenu)) {
					output.write("Status : True\n");
				} else {						
					output.write("Status : False\n");
				}
				output.write("\n");
			}
			output.flush();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
		System.out.println("Test end");
	}
}
