package fr.upmc.test.voteur;

public class CapteurData {

	public CapteurData(String data) throws CapteurDataException{
		try {
			if(data.length() < 1) {
				throw new CapteurDataException();
			} else {
				String valideS = data.substring(0, 1);
				String valeurS = data.substring(1);
			
				int valideInt = Integer.parseInt(valideS);
				switch(valideInt) {
				case 1 : this.valide = true; break;
				case 0 : this.valide = false; break;
				default : throw new CapteurDataException();
				}
				
				int valeurInt = Integer.parseInt(valeurS);
				if(valeurInt < 0 || valeurInt > 1023) {
					throw new CapteurDataException();
				} else {
					this.valeur = valeurInt;
				}				
			}			
		} catch (NumberFormatException nfe) {
			nfe.printStackTrace();
		}

	}

	public boolean isValide() {
		return valide;
	}
	public void setValide(boolean valide) {
		this.valide = valide;
	}
	public int getValeur() {
		return valeur;
	}
	public void setValeur(int valeur) {
		this.valeur = valeur;
	}

	private boolean valide;
	private int valeur;

}
