package fr.upmc.test.voteur;

public class Voteur {	
	private CapteurData[] cds = new CapteurData[3];
	
	public String voteur(String capteur1, String capteur2, String capteur3) {
		try {
			this.cds[0] = new CapteurData(capteur1);
			this.cds[1] = new CapteurData(capteur2);
			this.cds[2] = new CapteurData(capteur3);
		} catch (CapteurDataException e) {
			return "Error : Input number format must like [01][0-9]+";
		}
		
		int result = 0;
		boolean resultValide = false;
		if(cds[0].isValide() && cds[1].isValide() && cds[2].isValide()) {
			result = allValideResult();
		} else if(cds[0].isValide() && cds[1].isValide() && !cds[2].isValide()) {
			result = towValideResalt(0, 1);
		} else if(cds[0].isValide() && !cds[1].isValide() && cds[2].isValide()) {
			result = towValideResalt(0, 2);
		} else if(!cds[0].isValide() && cds[1].isValide() && cds[2].isValide()) {
			result = towValideResalt(1, 2);
		} else if(cds[0].isValide() && !cds[1].isValide() && !cds[2].isValide()) {
			result = oneValideResalt(0);
		} else if(!cds[0].isValide() && cds[1].isValide() && !cds[2].isValide()) {
			result = oneValideResalt(1);
		} else if(!cds[0].isValide() && !cds[1].isValide() && cds[2].isValide()) {
			result = oneValideResalt(2);
		} 
		
		if(result != 0) {
			resultValide = true;
		}
		
		return "" + cds[0].getValeur() + " " + cds[0].isValide() + " - " +
				cds[1].getValeur() + " " + cds[1].isValide() + " - " +
				cds[2].getValeur() + " " + cds[2].isValide() + " == " +
				result + " " + resultValide;
	}

	private int oneValideResalt(int i) {
		if(cds[i].getValeur() >= 70 && cds[i].getValeur() <= 950) {
			return cds[i].getValeur();
		}
		return 0;
	}

	private int towValideResalt(int i, int j) {
		if(Math.abs(cds[i].getValeur() - cds[j].getValeur()) <= 5) {
			return (cds[i].getValeur() + cds[j].getValeur()) / 2;
		}
		return 0;
	}

	private int allValideResult() {
		return (cds[0].getValeur() + cds[1].getValeur() + cds[2].getValeur()) / 3;		
	}

}
