module Voteur = struct

  type state = Valid | Invalid
  type reliability = Bad | Good
  type value = None | Value of int
  type sensor = state * value

  let are_coherent v1 v2 =
    abs (v1 - v2) <= 5

  let run s1 s2 s3 =
    match s1, s2, s3 with
      | (Valid, Value v1), (Valid, Value v2), (Valid, Value v3) ->
	Good, Value ((v1 + v2 + v3) / 3)
      | (Valid, Value v1), (Valid, Value v2), _
      | (Valid, Value v1), _, (Valid, Value v2)
      | _, (Valid, Value v1), (Valid, Value v2) ->
	if are_coherent v1 v2 then Good, Value ((v1 + v2) / 2) else Bad, None
      | (Valid, Value v), _, _
      | _, (Valid, Value v), _
      | _, _, (Valid, Value v) ->
	if v >= 70 && v <= 950 then Good, Value v else Bad, None
      | _ -> Bad, None
	
  let print s1 s2 s3 (r, v) =
    let print_sensor s =
      match s with
	| Invalid, _ -> Printf.printf "none false"
	| Valid, Value v -> Printf.printf "%d true" v
	| _ -> assert false
    in
    print_sensor s1; Printf.printf " - ";
    print_sensor s2; Printf.printf " - ";
    print_sensor s3; Printf.printf " == ";
    ( match (r, v) with
      | Bad, _ -> Printf.printf "none false"
      | Good, Value v -> Printf.printf "%d true" v
      | _ -> assert false );
    print_newline ()

end

open Voteur

exception BadFormat

let parse input =
  let length = String.length input in
  if length <= 1 then
    raise BadFormat
  else
    let state = input.[0]
    and value = String.sub input 1 (length - 1) in
    let state = int_of_char state
    and value = int_of_string value in
    if state = 0 then Invalid, None else Valid, Value value
      
let _ =
  try
    let a = parse (read_line ())
    and b = parse (read_line ())
    and c = parse (read_line ()) in
    let r = run a b c in
    print a b c r
    with 
      |	BadFormat -> Printf.fprintf stderr "Bad input format -> [01][0-9]+\n"
      | End_of_file -> ()
    
