#!/usr/bin/env python

import sys
import subprocess

def conv(r):
    t = {"false": "0", "true": "1"}
    return t[r[1]]+r[0]

if __name__ == '__main__':
    if len(sys.argv) != 2:
        print "USAGE : ./runtest.py <tests_file>"
        sys.exit(1)
    try:
        f1 = open(sys.argv[1])
    except:
        print "Erreur a l'ouverture de ", sys.argv[1]
    f2 = open(sys.argv[1]+"_results", "w")
    tests = f1.read().strip().split('\n')
    f1.close()
    for test in tests:
        if not test or test[0] == '#':
            f2.write(test + "\n")
            continue
        t = ("\n".join(test.split(' ')[:3])) + "\n"
        s = subprocess.Popen(['./runvoteur.py'],
                             stdin = subprocess.PIPE,
                             stdout = subprocess.PIPE,
                             stderr = subprocess.STDOUT)
        s.stdin.write(t)
        s.stdin.flush()
        s.stdin.close()
        result = s.stdout.readline().strip()
        if " == " in result:
            result = result.split(" == ")
            result = conv(result[-1].split(" "))
        f2.write(test + " " + result + "\n")
        s.stdout.close()
    f2.close()
    print "Tests done."
    print "Results are in \"" + sys.argv[1]+"_results" + "\" file"

