﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace VoteurCoder
{
    public class Coder
    {
        #region Methodes Coder
        public static String VoteurCoder(bool isValide, int value)
        {
            char[] codes = new char[11];
            int diff;

            codes[0] = (value < 0 || value >= 1024) ? '0' : (isValide ? '1' : '0');
            if (value < 0 || value >= 1024)
            {
                for (int i = 1; i < 11; i++)
                {
                    codes[i] = '0';
                }
                return new String(codes);
            }

            for (int i = 1; i < 11; i++)
            {
                diff = (int)Math.Pow(2, (10 - i));
                codes[i] = (Convert.ToChar((value / diff) + ""));
                if (value >= diff) value -= diff;
            }

            return new String(codes);
        }

        public static String VoteurCoder(string input)
        {
            input = input.Trim();
            string temp = input.Substring(0, 1);
            bool isValide = (temp.Equals("1"));
            temp = input.Substring(1, input.Length - 1);
            int value = 0;
            if (IsNum(temp))
            {
                value = Int32.Parse(temp);
            }
            return VoteurCoder(isValide, value);

        }

        public static String[] VoteurCoderTout(string input)
        {
 
            String[] votes = input.Split('\n');
            String[] res = new String[3];
            if (votes.Length < 3) return null;
            for (int i = 0; i < 3; i++)
            {
                res[i] = VoteurCoder(votes[i]);
            }

            return res;

        } 
        #endregion

        #region Methodes Decoder
        public static Result VoteurDecoder(char[] codes)
        {
            Result res;

            res.isValide = Convert.ToBoolean(Int16.Parse(codes[0] + ""));
            res.value = 0;
            for (int i = 1; i < 11; i++)
            {
                res.value += Int16.Parse(codes[i] + "") * ((int)(Math.Pow(2, (10 - i))));
            }

            return res;
        }

        public static Result[] VoteurDecoderTout(string[] votes)
        {
            Result[] res = new Result[4];
            for (int i = 0; i < 3; i++)
            {
                if (IsNum(votes[i]))
                {
                    res[i] = VoteurDecoder(votes[i].ToCharArray());
                }
                else
                {
                    res[3].isValide = false;
                    res[3].value = -1;
                    return res;
                }

            }

            return res;
        } 
        #endregion

        #region Methodes Outil
        public static bool IsNum(string str)
        {
            for (int i = 0; i < str.Length; i++)
            {
                if (str[i] < '0' || str[i] > '9')
                    return false;
            }
            return true;
        } 
        #endregion
    }

    public struct Result
    {
        public bool isValide;
        public int value;
    }
}
