﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VoteurCoder;

namespace VoteurLib
{
    public class Voteur
    {
        public static List<Result> Traitement(String input)
        {
            List<Result> res = new List<Result>();
            String[] votes = Coder.VoteurCoderTout(input);
            if (votes == null) return null;
            res.AddRange(Coder.VoteurDecoderTout(votes));
            return res;
        }

        public static string CalculerVotes(Result[] res)
        {
            if (res[3].value == -1)
            {
                return "Erreur d'entree";
            }

            List<Result> valideRes = new List<Result>();
            List<Result> nonValideRes = new List<Result>();
            string resStr = "";
            int resValue = 0;

            #region Construire le string de resultat, garder les parametres
            for (int i = 0; i < 3; i++)
            {
                if (i != 0) resStr += "-";
                resStr += " " + res[i].value + " " + res[i].isValide + " ";
            } 
            #endregion

            #region Filtre les resultats valide
            for (int i = 0; i < 3; i++)
            {
                if (res[i].isValide)
                    valideRes.Add(res[i]);
            }
            #endregion

            #region Construire le resultat final
            switch (valideRes.Count)
            {
                case 3:
                    for (int i = 0; i < 3; i++)
                    {
                        resValue += valideRes[i].value;
                    }
                    resStr += "= " + (resValue / 3) + " " + true + "\n";
                    break;
                case 2:
                    if (Math.Abs(valideRes[0].value - valideRes[1].value) <= 5)
                    {
                        res[3].isValide = true;
                        res[3].value = (valideRes[0].value + valideRes[1].value) / 2;
                    }
                    resStr += "= " + res[3].value + " " + res[3].isValide + "\n";
                    break;
                case 1:
                    if (valideRes[0].value >= 70 && valideRes[0].value <= 950)
                    {
                        res[3] = valideRes[0];
                    }
                    resStr += "= " + res[3].value + " " + res[3].isValide + "\n";
                    break;
                default:
                    resStr += "= " + 0 + " " + false + "\n";
                    break;
            } 
            #endregion

            return resStr;
        }


        /// <summary>
        /// Cette methode est sur la base de CalculerVotes, elle est modifiée
        /// pour s'adapter au TP2.
        /// </summary>
        /// <param name="input"></param>
        /// <returns>Le resultat sous forme de chaine caractère, en format de "bd", où b est la valide du resultat avec 0 ou 1, d est la value du resultat.</returns>
        public static string CalculerVotesTP2(String input)
        {
            input = input.Replace(" ", "\n");
            List<Result> res = Voteur.Traitement(input);
            if (res == null || res[3].value == -1)
            {
                return "Erreur d'entree";

            }

            List<Result> valideRes = new List<Result>();
            List<Result> nonValideRes = new List<Result>();
            string resStr = "";
            int resValue = 0;

            #region Construire le string de resultat, garder les parametres
            for (int i = 0; i < 3; i++)
            {
                if (i != 0) resStr += "-";
                resStr += " " + res[i].value + " " + res[i].isValide + " ";
            }
            #endregion

            #region Filtre les resultats valide
            for (int i = 0; i < 3; i++)
            {
                if (res[i].isValide)
                    valideRes.Add(res[i]);
            }
            #endregion

            #region Construire le resultat final
            switch (valideRes.Count)
            {
                case 3:
                    for (int i = 0; i < 3; i++)
                    {
                        resValue += valideRes[i].value;
                    }
                    resStr = "1" + (resValue / 3);
                    break;
                case 2:
                    int valide = 0;
                    if (Math.Abs(valideRes[0].value - valideRes[1].value) <= 5)
                    {
                        valide = 1;
                        resValue = (valideRes[0].value + valideRes[1].value) / 2;
                    }
                    resStr = valide + ""+ resValue;
                    break;
                case 1:
                    if (valideRes[0].value >= 70 && valideRes[0].value <= 950)
                    {
                        res[3] = valideRes[0];
                    }
                    resStr = ((res[3].isValide) ? "1" : "0") + res[3].value;
                    break;
                default:
                    resStr += "= " + 0 + " " + false + "\n";
                    resStr = "00";
                    break;
            }
            #endregion



            return resStr;
        }



    }


}
