﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using VoteurLib;
using System.Threading;

namespace VoteurTP2
{
    class Program
    {
        static void Main(string[] args)
        {
            if (args.Length < 1)
            {
                Console.WriteLine("USAGE: VoteurTP2 [File]");
                Console.ReadLine();
                return;
            }


            List<string> res = new List<string>();

            FileStream sInput = new FileStream(args[0], FileMode.Open);
            Console.SetIn(new StreamReader(sInput));

            FileStream sOutput = new FileStream(args[0]+".out", FileMode.Create);
            Console.SetOut(new StreamWriter(sOutput));

            while (sInput.CanRead)
            {
                // Recuperer le str depuis la chaine stdin
                string input = Console.In.ReadLine();
                if (input == null) break;

                // Calculer les votes en utilisant le composant du TP1
                string resultat = Voteur.CalculerVotesTP2(input);

                // Ajouter dans la liste de resultat
                res.Add(input + " " + resultat);

            }

            foreach (string str in res)
            {   
                // Ecrire le resultat dans la chaine stdout
                Console.Out.WriteLine(str);
                Console.Out.Flush();
            }

            sInput.Close();
            sOutput.Close();

        }


    }
}
