﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using VoteurLibrary;

namespace ProgrammeVoteur
{
    class ProgrammeVoteur
    {
        static void Main(string[] args)
        {
            string[] input = new string[3];
            Capteur<bool, int>[] capteurs =
            { 
                new Capteur<bool, int>(), 
                new Capteur<bool, int>(), 
                new Capteur<bool, int>() 
            };

            for (int i = 0; i < 3; i++)
            {
                input[i] = Console.ReadLine();
                input[i] = input[i].Replace('\n', '\0');
                Match m = Regex.Match(input[i], @"(0|1)[0-9]+");

                if (!m.Success)
                {
                    Console.WriteLine("Error");
                    //Console.Read();
                    return;
                }

                try
                {
                    capteurs[i].First = (input[i][0] == '1');
                    capteurs[i].Second = int.Parse(input[i].Substring(1));
                }
                catch
                {
                    Console.WriteLine("Error");
                    //Console.Read();
                    return;
                }

                if (capteurs[i].Second < 0 || capteurs[i].Second > 1023)
                {
                    Console.WriteLine("Error");
                   // Console.Read();
                    return;
                }
            }

            Voteur voteur = new Voteur();
            Capteur<bool, int> result = voteur.DoVoteur(capteurs[0], capteurs[1], capteurs[2]);

            string output = "";
            output += (capteurs[0].Second + " " + capteurs[0].First + " - ");
            output += (capteurs[1].Second + " " + capteurs[1].First + " - ");
            output += (capteurs[2].Second + " " + capteurs[2].First + " == ");
            output += (result.Second + " " + result.First);

            Console.WriteLine(output);
            //Console.Read();
            return;
        }
    }
}
