﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.IO;

namespace TestVoteur
{
    class TestVoteur
    {
        static void Main(string[] args)
        {
            try
            {
                string[] inputLines = System.IO.File.ReadAllLines(@args[0]);

                Console.WriteLine("reading test file successful");
                
                System.IO.File.WriteAllText(@"./output.txt", "");

                Process appliVoteur = Launcher();

                foreach (string line in inputLines)
                {
                    if (line == "-")
                    {
                        string output = appliVoteur.StandardOutput.ReadLine();
                        System.IO.File.AppendAllText(@"./output.txt", output + Environment.NewLine);

                        appliVoteur.StandardInput.Close();
                        appliVoteur.StandardOutput.Close();
                        if(!appliVoteur.HasExited) appliVoteur.Kill();

                        appliVoteur = Launcher();
                    }
                    else
                    {
                        appliVoteur.StandardInput.WriteLine(line);
                    }
                }

                string output2 = appliVoteur.StandardOutput.ReadLine();
                System.IO.File.AppendAllText(@"./output.txt", output2);

                appliVoteur.StandardInput.Close();
                appliVoteur.StandardOutput.Close();
                if (!appliVoteur.HasExited) appliVoteur.Kill();
            }
            catch
            {
                Console.WriteLine("Error");
                Console.Read();
                return;
            }

            Console.WriteLine("Success");
            Console.Read();
        }

        private static void SaveOutput(object sendingProcess, DataReceivedEventArgs outLine)
        {
            Console.WriteLine("fc,zedcn,");
            Console.WriteLine(outLine.Data);
            System.IO.File.WriteAllText(@"./output.txt", outLine.Data);
        }

        private static Process Launcher()
        {
            Process appliVoteur = new Process();
            appliVoteur.StartInfo.FileName = "ProgrammeVoteur.exe";
            appliVoteur.StartInfo.UseShellExecute = false;
            appliVoteur.StartInfo.CreateNoWindow = true;
            appliVoteur.StartInfo.RedirectStandardInput = true;
            appliVoteur.StartInfo.RedirectStandardOutput = true;

            appliVoteur.Start();

            Console.WriteLine("launching voteur successful");

            return appliVoteur;
        }
    }
}
