﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace VoteurLibrary
{
    public class Voteur
    {
        private Capteur<bool, int> firstSensor;
        private Capteur<bool, int> secondSensor;
        private Capteur<bool, int> thirdSensor;

        public Voteur()
        {
            firstSensor = new Capteur<bool, int>();
            secondSensor = new Capteur<bool, int>();
            thirdSensor = new Capteur<bool, int>();
        }

        public Capteur<bool, int> DoVoteur(
            Capteur<bool, int> firstSensor, 
            Capteur<bool, int> secondSensor,
            Capteur<bool, int> thirdSensor
            )
        {
            Capteur<bool, int> output = new Capteur<bool, int>();

            if (firstSensor.First && secondSensor.First && thirdSensor.First)
            {
                output.First = true;
                output.Second = (firstSensor.Second + secondSensor.Second + thirdSensor.Second) / 3;

                return output;
            }

            if (firstSensor.First && secondSensor.First)
            {
                output.First = Math.Abs(firstSensor.Second - secondSensor.Second) <= 5;
                output.Second = output.First ? (firstSensor.Second + secondSensor.Second) / 2 : 0;

                return output;
            }

            if (firstSensor.First && thirdSensor.First)
            {
                output.First = Math.Abs(firstSensor.Second - thirdSensor.Second) <= 5;
                output.Second = output.First ? (firstSensor.Second + thirdSensor.Second) / 2 : 0;

                return output;
            }

            if (thirdSensor.First && secondSensor.First)
            {
                output.First = Math.Abs(thirdSensor.Second - secondSensor.Second) <= 5;
                output.Second = output.First ? (thirdSensor.Second + secondSensor.Second) / 2 : 0;

                return output;
            }

            if (firstSensor.First && (firstSensor.Second >= 70) && (firstSensor.Second <= 950))
            {
                output.First = true;
                output.Second = firstSensor.Second;

                return output;
            }

            if (secondSensor.First && (secondSensor.Second >= 70) && (secondSensor.Second <= 950))
            {
                output.First = true;
                output.Second = secondSensor.Second;

                return output;
            }

            if (thirdSensor.First && (thirdSensor.Second >= 70) && (thirdSensor.Second <= 950))
            {
                output.First = true;
                output.Second = thirdSensor.Second;

                return output;
            }

            output.First = false;
            output.Second = 0;

            return output;
        }
    }

    public class Capteur<T, U>
    {
        public T First
        {
            get;
            set;
        }

        public U Second
        {
            get;
            set;
        }
    }
}
