#!/bin/bash
# v1.0 2012-02-15 Th. Paulin

set +x

aide() {
	echo "Syntaxe : $0 -f nom_du_fichier -p nom_du_programme"
}

# Vérification que /usr/bin/awk est utilisable
if [ ! -x "/usr/bin/awk" ] ; then
	echo "Le programme "/usr/bin/awk" est nécessaire pour réaliser le test"
	exit 1
fi

# Vérification que le programme /bin/cat est utilisable
if [ ! -x "/bin/cat" ] ; then
	echo "Le programme "/bin/cat" est nécessaire pour réaliser le test"
	exit 2
fi

# Vérification que le programme a bien l'indicateur du premier argument
if [ -z "$1" ] ; then
	aide
	exit 3
fi

# Vérification que le programme est appelé avec l'option -f
if [ "$1" != "-f" ] ; then
	aide
	exit 4
fi

# Vérification que le programme est appelé avec un argument
if [ -z "$2" ] ; then
	aide
	exit 5
fi

# Vérification que le programme a un nom de fichier en argument
if [ ! -e "$2" ] ; then
	echo "Le fichier « $2 » n'a pas été trouvé"
	exit 6
fi

# Vérfication que le fichier est bien un fichier régulier
if [ ! -f "$2" ] ; then
	echo "Le fichier « $2 » n'est pas un fichier régulier"
	exit 7
fi

# Vérification que le fichier est lisible
if [ ! -r "$2" ] ; then
	echo "Le fichier « $2 » n'est pas lisible"
	exit 8
fi

# Vérification que le programme a bien l'indicateur du deuxième argument
if [ -z "$3" ] ; then
	aide
	exit 9
fi

# Vérification que le programme est appelé avec l'option -p
if [ "$3" != "-p" ] ; then
	aide
	exit 10
fi

# Vérification que le programme est appelé avec un argument
if [ -z "$4" ] ; then
	aide
	exit 11
fi

# Vérification que le programme a un nom de fichier en argument
if [ ! -e "$4" ] ; then
	echo "Le fichier « $4 » n'a pas été trouvé"
	exit 12
fi

# Vérfication que le fichier est bien un fichier régulier
if [ ! -f "$4" ] ; then
	echo "Le fichier « $4 » n'est pas un fichier régulier"
	exit 13
fi

# Vérification que le fichier est exécutable
if [ ! -x "$4" ] ; then
	echo "Le fichier « $4 » n'est pas lisible"
	exit 14
fi

NOMBRE_LIGNES=$(wc -l $2 | awk '{print $1}')

# Génération des résultats
awk -v programme="$4" '
	{
		print $1 "\n" $2 "\n" $3 > "/tmp/jeu" FNR ;
		#print "Essai n° " FNR ;
		system(programme "< /tmp/jeu" FNR " > /tmp/res" FNR " 2> /dev/null") ;
		system("rm /tmp/jeu" FNR) ;
	}
' $2

declare -a resultats

for (( a = 1 ; a <= $NOMBRE_LIGNES ; a++ )) ; do
	resultats[$a]=$(cat /tmp/res$a|tr ":" "\n"|grep "==")
	if [ -z "${resultats[$a]}" ] ; then
		resultats[$a]="ERR"
	else
		resultats[$a]=$(
			echo ${resultats[$a]} | awk -F== '
				{
					split($2,resultat," ")
					if ( "false" == resultat[2] )
						print "0" resultat[1]
					else
						print "1" resultat[1]
				}
			'
		)
	fi
done

for (( a = 1 ; a <= $NOMBRE_LIGNES ; a++ )) ; do
awk -v retour=${resultats[$a]} -v ligne=$a '
	{
		if ( ligne == FNR )
			print $0 " " retour
	}
' $2
done

for (( a = 1 ; a <= $NOMBRE_LIGNES ; a++ )) ; do
	rm /tmp/res$a
done
