﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using data;

namespace _1_Voteur {
    class Voteur {
        public static Data voteur(List<string> in_) {
            List<Data> input = new List<Data>();
            foreach (string s in in_)
                input.Add(new Data(int.Parse(s.Substring(1)), s[0] == '0' ? false : true));

            var ret = new Data();
            List<Data> capteursValides = new List<Data>();
            foreach (Data d in input)
                if (d.Valid)
                    capteursValides.Add(d);

            switch (capteursValides.Count) {
                case 3:
                    ret.Val = GetMean(capteursValides);
                    ret.Valid = true;
                    break;
                case 2:
                    if (Math.Abs(capteursValides[0].Val - capteursValides[1].Val) <= 5) {
                        ret.Val = GetMean(capteursValides);
                        ret.Valid = true;
                    }
                    break;
                case 1:
                    if (capteursValides[0].Val >= 70 && capteursValides[0].Val <= 950) 
                        ret = capteursValides[0];
                    break;
                default:
                    break;
            }

            return ret;
        }

        private static int GetMean(List<Data> capteurs) {
            var total = 0;
            foreach (Data d in capteurs)
                total += d.Val;
            return total / capteurs.Count;
        }
    }

    
}
