﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.IO;

namespace Test_Voteur {
    class Program {
        static string text = "";
        static void Main(string[] args) {

            string[] lines = System.IO.File.ReadAllLines(@args[0]);
            foreach (string line in lines) {
                string[] strings = line.Split(new char[] {' '}, StringSplitOptions.RemoveEmptyEntries);
                text += line + " ";
                Console.WriteLine(Valid(strings));
                switch (Valid(strings)) {
                    case errorCode.OK:
                        string capteur1 = strings[0].Substring(1);
                        bool valid1 = strings[0][0] == '0' ? false : true;
                        string capteur2 = strings[1].Substring(1);
                        bool valid2 = strings[1][0] == '0' ? false : true;
                        string capteur3 = strings[2].Substring(1);
                        bool valid3 = strings[2][0] == '0' ? false : true;
                        string expectedValue = strings[3].Substring(1);
                        bool expectedValid = strings[3][0] == '0' ? false : true;


                        ProcessStartInfo psi = new ProcessStartInfo();
                        psi.FileName = "1_Voteur.exe";
                        psi.UseShellExecute = false;
                        psi.RedirectStandardInput = true;
                        psi.RedirectStandardOutput = true;
                        Process proc = new Process();
                        proc.StartInfo = psi;



                        if (proc.Start()) {
                            proc.StandardInput.WriteLine(strings[0]);
                            proc.StandardInput.WriteLine(strings[1]);
                            proc.StandardInput.WriteLine(strings[2]);

                            StreamReader outputReader = proc.StandardOutput;
                            outputReader.ReadLine();
                            outputReader.ReadLine();
                            outputReader.ReadLine();
                            text+=outputReader.ReadLine();


                            if (!proc.HasExited)
                                proc.Kill();
                        }
                        break;
                    default:
                        text += "error";
                        break;
                }
                text += Environment.NewLine;
            }
            //écrire dans fichier de sortie:
            System.IO.File.WriteAllText(@args[1], text);
        }

        static errorCode Valid(string[] args) {
            try {
                if (args.Length != 4)
                    return errorCode.DIFFERENT_THAN_FOUR_PARAMS;
                if (!GetValues(new string[] {args[0], args[1], args[2]}))
                    return errorCode.BAD_PARAM;
                if (!CheckValuesSize(new string[] { args[0], args[1], args[2] }))
                    return errorCode.VALUES_OUT_OF_RANGE;
                return errorCode.OK;
            }
            catch {
                return errorCode.BAD_FORMAT;
            }
        }
        static bool GetValues(string [] values) {
            foreach (string s in values) {
                if (s[0] != '0' && s[0] != '1')
                    return false;
                try{
                    int.Parse(s.Substring(1));
                }
                catch{
                    return false;
                }
            }
            return true;
        }

        static bool CheckValuesSize(string [] values) { //en admettant que l'on ne considère que les entiers codés sur 10 bits non signés
            foreach (string s in values) {
                if(s[0] == '1')
                    if (Convert.ToInt32(s.Substring(1)) < 0 || Convert.ToInt32(s.Substring(1)) > 1023)
                        return false;
            }
            return true;
        }

        enum errorCode {
            DIFFERENT_THAN_FOUR_PARAMS, //un seul paramètre doit être fournit à l'application
            BAD_PARAM, //paramètre mal formé
            VALUES_OUT_OF_RANGE, //valeurs des capteurs trop grande/trop petite
            BAD_FORMAT, //paramètre mal formé
            OK //tout va bien
        }
    
    }
}
