﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BibliothequeVoteur
{
    public class Voteur
    {
        public static void DataExceptionDetect(Capteur cap) 
        {
            if (cap.Valeur < 0 || cap.Valeur > 1023)
                throw new InvalidDataException(cap.ValidateInt.ToString() + "\"" + cap.Valeur.ToString() + "\"");
            if (cap.ValidateInt < 0 || cap.ValidateInt > 1)
                throw new InvalidDataException("\"" + cap.ValidateInt.ToString()+ "\"" + cap.Valeur.ToString());
        }

        public static Capteur FVoteur(Capteur cap1, Capteur cap2, Capteur cap3) {
            Capteur res = new Capteur();
            res.ValidateInt = 0;
            res.Valeur = 0;

            List<Capteur> caps = new List<Capteur>();
            caps.Add(cap1);
            caps.Add(cap2);
            caps.Add(cap3);
            foreach (Capteur c in caps) 
            {
                DataExceptionDetect(c);
            }
            switch (cap1.ValidateInt + cap2.ValidateInt + cap3.ValidateInt) { 
                case 3:
                    res.ValidateInt = 1;
                    res.Valeur = (cap1.Valeur + cap2.Valeur + cap3.Valeur) / 3;
                    break;
                case 2:
                    int sub = 0;
                    int sum = 0;
                    bool flag = false;
                    foreach(Capteur c in caps){
                        if (c.ValidateBool) {
                            sum += c.Valeur;
                            if (flag == false)
                            {
                                flag = true;
                                sub += c.Valeur;
                            }
                            else {
                                sub -= c.Valeur;
                                break;
                            }
                        }
                    }
                    if (Math.Abs(sub) <= 5) 
                    { 
                        res.ValidateInt = 1;
                        res.Valeur = sum / 2;
                    }
                    break;
                case 1:
                    foreach (Capteur c in caps) {
                        if (c.ValidateBool && c.Valeur <= 950 && c.Valeur >= 70)
                        {
                            res.ValidateInt = 1;
                            res.Valeur = c.Valeur;
                            break;
                        }
                    }
                    break;
                default :
                    Console.WriteLine("Aucun capteur est disponible.");
                    break;
                   
            }

            return res;
        }

        public static Capteur Decoder(string str)
        {
            Capteur cap = new Capteur();
            if (str == "")
            {
                cap.ValidateInt = 0;
                cap.Valeur = 0;
            }
            else
            {
               
                    cap.ValidateInt = int.Parse(str.Substring(0, 1));
                    cap.Valeur = int.Parse(str.Substring(1, str.Length - 1));
                
            
            }
            return cap;
        }

        public static string Coder(Capteur cap)
        {
            return cap.ValidateInt + cap.Valeur.ToString();
        }
    }
}
