package test;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.InvalidParameterException;
import java.util.ArrayList;

import voter.Sensor;
import voter.Voter;

public class Test {
	public static final String INPUT_INVALID = "ERROR";

	/**
	 * @param args
	 * @throws IOException
	 */
	public static void main(String[] args) throws IOException {
		try {
			FileInputStream fstream = new FileInputStream("data/data.txt");
			DataInputStream in = new DataInputStream(fstream);
			BufferedReader br = new BufferedReader(new InputStreamReader(in));
			String strLine;
			String result;
			while ((strLine = br.readLine()) != null) {
				if (strLine == null || strLine.equals(""))
					continue;
				if (strLine.contains("//")) {
					writeToFile("data/out.txt", "\n" + strLine + "\n");
					continue;
				}
				result = calculate(strLine);
				result = strLine + " " + result;
				writeToFile("data/out.txt", result + "\n");
			}
			in.close();
		} catch (Exception e) {
			System.err.println("Error: " + e.getMessage());
		}
	}

	private static void writeToFile(String fileName, String content) {
		try {
			FileWriter fstream = new FileWriter(fileName, true);
			BufferedWriter out = new BufferedWriter(fstream);
			out.write(content);
			out.close();
		} catch (Exception e) {
			System.err.println("Error: " + e.getMessage());
		}
	}

	private static String calculate(String inputData) {
		ArrayList<Sensor> sensors = new ArrayList<Sensor>();
		String data[] = inputData.split(" ");
		for (int i = 1; i < 4; i++) {
			int state;
			int value;
			try
			{
				state = Integer.parseInt(data[i].substring(0, 1));
				value = Integer.parseInt(data[i].substring(1));
			}
			catch (Exception e) {
				return INPUT_INVALID;
			}
			Sensor sensor = new Sensor();

			if (state == 1)
				sensor.setState(true);
			else if (state == 0)
				sensor.setState(false);
			else
				return INPUT_INVALID;

			if (value > 1023 || value < 0)
				return INPUT_INVALID;
			sensor.setValue(value);
			sensors.add(sensor);
		}
		String result = Voter.vote(sensors.get(0), sensors.get(1),
				sensors.get(2));
		return result;
	}

}
