package voter;

import java.text.NumberFormat;
import java.util.ArrayList;

public class Voter {
	public static String vote(Sensor s1, Sensor s2, Sensor s3) {
		StringBuffer result = new StringBuffer();
		ArrayList<Sensor> validSensors = findValidSensors(s1, s2, s3);
		NumberFormat nf = NumberFormat.getInstance();
		int sum = 0;
		if (validSensors.size() == 3) {
			// First
			sum += validSensors.get(0).getValue();
			sum += validSensors.get(1).getValue();
			sum += validSensors.get(2).getValue();
			// Result
			if (sum != 0)
				sum = sum / 3;
			result.append("1");
			result.append(sum);
		} else if (validSensors.size() == 2) {
			// First
			sum += validSensors.get(0).getValue();
			sum += validSensors.get(1).getValue();

			// Result
			if (sum != 0)
				sum = sum / 2;

			// Tolerance <= 5
			if (Math.abs(validSensors.get(0).getValue()
					- validSensors.get(1).getValue()) <= 5) {
				result.append(1);
				result.append(sum);
			} else
				result.append(0);

		} else if (validSensors.size() == 1) {
			// Tolerance between 70 and 950
			if (validSensors.get(0).getValue() >= 70
					&& validSensors.get(0).getValue() <= 950) {
				result.append(1);
				// First
				result.append(validSensors.get(0).getValue());
			} else
				result.append(0);

		} else if (validSensors.size() == 0)
			result.append(0);
		return result.toString();

	}

	private static ArrayList<Sensor> findValidSensors(Sensor s1, Sensor s2,
			Sensor s3) {
		ArrayList<Sensor> validSensors = new ArrayList<Sensor>();
		if (s1.getState())
			validSensors.add(s1);
		if (s2.getState())
			validSensors.add(s2);
		if (s3.getState())
			validSensors.add(s3);
		return validSensors;
	}
}
