import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import java.util.StringTokenizer;

public class Voteur {

	/**
	 * @param args
	 */

	static Capteur[] capteurs = new Capteur[3];

	// programme princpal
	public static void main(String[] args) {
		String chaine="";
//		if (args.length==0) 
//			System.err.println("Veullez entrer le nom du fichier");

		
		File fichier =new File("voteur.txt");
		/**Cration du fichier de sortie**/
		FileWriter fw;
		BufferedWriter output = null;
		try {
			fw = new FileWriter("voteur_result.txt", false);
			output = new BufferedWriter(fw);
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		try{
			InputStream ips=new FileInputStream(fichier); 
			InputStreamReader ipsr=new InputStreamReader(ips);
			BufferedReader br=new BufferedReader(ipsr);
			String ligne;
			String[] tmp;
			while ((ligne=br.readLine())!=null){
				tmp=ligne.split(" ");

				boolean valide=true;		
				for (int i = 1; i < 4; i++) {
					if (!isValid(tmp[i]))
						valide=false;
					
				}	
				
				for (int i = 1; i < 4; i++) {
						capteurs[i-1] = makeCapteur(tmp[i]);
						
				}
		
				if (valide==true)
				output.write(tmp[0]+" "+voteur(capteurs,tmp[4])+"\n");
				else
				output.write(tmp[0]+" "+tmp[1]+" "+tmp[2]+" "+tmp[3]+" "+tmp[4]+" ERREUR \n");	
				output.flush();
		
			}
			
			br.close();
			output.close();
		}		
		catch (Exception e){
			System.out.println(e.toString());
		}
		
		
		
		

		
		
	}

	/**
	 * methode principale contenant la partie mtier de voteur
	 * */
	private static String voteur(Capteur[] capteurs,String resultatAttendu) {

		int tolerance = 5;
		int nbCapteursCoherent = 2;
		int somme = 0;
		int avg = 0;
		boolean resValidity = false;
		String res = "";
		ArrayList<Capteur> listCapteurs = new ArrayList<Capteur>();

		for (int i = 0; i < capteurs.length; i++) {
			if (capteurs[i].getValidity() == 1) {
				listCapteurs.add(capteurs[i]);
			}
			res += capteurs[i] +" ";
		}

		// tous les capteurs sont valides
		if (listCapteurs.size() == capteurs.length) {
			resValidity = true;
			for (int i = 0; i < capteurs.length; i++) {
				somme += capteurs[i].getValue();
			}
			avg =  (somme / capteurs.length);

			// seuls 2 sont valides
		} else if (listCapteurs.size() == nbCapteursCoherent) {
			if (Math.abs(listCapteurs.get(0).getValue()
					- listCapteurs.get(1).getValue()) <= tolerance) {
				resValidity = true;
				somme = listCapteurs.get(0).getValue()
						+ listCapteurs.get(1).getValue();
				avg = (int) (somme / nbCapteursCoherent);
			}

			// 1 seul est valide !
		} else if (listCapteurs.size() == 1) {
			avg = listCapteurs.get(0).getValue();
			resValidity = (listCapteurs.get(0).getValue() >= 70 || listCapteurs
					.get(0).getValue() >= 950) ? true : false;
			if (resValidity==false)
				avg=0;
		} else if (listCapteurs.size() < 1) {
			resValidity = false;
		}

		//res = res.substring(0, res.length() - 3);
		int avgvalidity;
		if (resValidity==true)
			avgvalidity=1;
		else 
			avgvalidity=0;
		
	return res +resultatAttendu+" "+avgvalidity+avg;
	}

	/**
	 * analyse la chaine de caractre de l'utilisateur, pour bien distinguer la
	 * partie validit de la partie valeur
	 */
	public static Capteur makeCapteur(String nb) {

		int valid = Integer.parseInt(nb.substring(0, 1));
		int value = Integer.parseInt(nb.substring(1, nb.length()));
		return new Capteur(valid, value);
	}

	/**
	 * verifie que la chaine lue est un entier qui respect le format [0|1][0-9]+
	 */
	private static boolean isValid(String nb) {

		String validity = "";
		String value = "";

		if (nb.length() < 2 || nb.length() > 5)
			return false;

		try {

			validity = nb.substring(0, 1);
			value = nb.substring(1, nb.length());
			return validity.matches("0|1")
					&& (Integer.parseInt(value) >= 0 && Integer.parseInt(value) <= 1023);
		} catch (NumberFormatException e) {
			return false;
		}
	}
}
