import java.util.ArrayList;

public class VoteurResult {
	private int value = 0;
	private boolean valide = false;
	
	public VoteurResult(CapteurData[] capteurs){
		int numValide = 0;
		ArrayList<Integer> valideValues = new ArrayList<Integer>();
		for(int i = 0; i < capteurs.length; i++){
			if(capteurs[i].isValide()){
				numValide++;
				valideValues.add(capteurs[i].getValue());
			}
		}
		if(numValide == 1){
			if((valideValues.get(0) >= 70)&&(valideValues.get(0) <= 950)){
				value = valideValues.get(0);
				valide = true;
			}
		}else if(numValide == 2){
			if(Math.abs(valideValues.get(0) - valideValues.get(1)) <= 5){
				value = (valideValues.get(0) + valideValues.get(1))/2;
				valide = true;
			}
		}else if(numValide >= 3){
			int sum = 0;
			for(int v : valideValues){
				sum += v;
			}
			value = sum/valideValues.size();
			valide = true;
		}
	}
	
	public String toString(){
		String s = String.valueOf(valide)+" "+String.valueOf(value);
		return s;
	}
}
