#!/usr/bin/env python

import sys
import subprocess

debug = False

def usage():
	print "usage : " + sys.argv[0] + " file"

def run (command, str):
	process = subprocess.Popen([command], stdin=subprocess.PIPE, stdout=subprocess.PIPE)
	if debug:
		print "    ** " + command + " << "
		print "---"
		print str
		print "---"
	result = process.communicate(str)[0].strip()
	return result

def main():
	if len(sys.argv) < 2:
		usage()
		sys.exit(0)
	
	try:
		finput = open (sys.argv[1])
	except:
		print "impossible to open file " + sys.argv[1]
		sys.exit(-1)

	while True:
		expected_line = finput.readline()
		if len (expected_line) == 0:
			break
		if (len (expected_line) > 0) and (expected_line[0] == '#' or expected_line[0] == '\n' or expected_line[0] == '\r'):
			continue
		expected_line = expected_line.strip()
		expected = expected_line.split(' ')
		if debug:
			print "expected : " + "\nexpected : ".join(expected)
		voteur = subprocess.Popen(["./voteur"], stdin=subprocess.PIPE, stdout=subprocess.PIPE)
	
		## fields 0-2 are the sensors results (as arguments)
		#result_line  = run("cat", "\n".join(expected[0:3]))
		result_line  = run("./voteur", "\n".join(expected[0:3]))
		result = result_line.split(' ')

		## field 3 and 4 are the results and need to be checked
		if debug:
			print "expected[3]='%s' - result[10]='%s'" % (expected[3], result[10])
			print "expected[4]='%s' - result[ 9]='%s'" % (expected[4], result[9])
		if expected[3] == result[10] and expected[4] == result[9]:
			print "%-45s %s" % (expected_line, "OK")
		else:
			print "%-45s %s" % (expected_line, "ERROR")

main()

