let debug = false

let avg_check_2 c1 c2 = 
if (abs (c1 - c2)) < 5 then
    (true, (c1 + c2) / 2)
else
    (false, 0)

let check c1 = 
if (c1 > 69) && (c1 < 951) then
    (true, c1)
else
    (false, 0)


let voteur c1 v1 c2 v2 c3 v3 = 
match (v1, c1, v2, c2, v3, c3) with 
| (true,  c1, true, c2, true, c3 ) -> (true, (c1 + c2 + c3) / 3)
| (true,  c1, true, c2, false, _)
| (true,  c1, false, _, true, c2)
| (false, _, true, c1, true, c2) -> avg_check_2 c1 c2
| (true, c1, false, _, false, _)
| (false, _, true, c1, false, _)
| (false, _, false, _, true, c1) -> check c1
| (false, _, false, _, false, _) -> (false, 0)

exception InvalidInputException

let voteur_input_line fd = 
let line = input_line fd in
if debug then 
    Printf.printf "input is : '%s'\n" line;
let valid, value =
(
   try
      Scanf.sscanf line "%c%d" (fun x y -> (x,y))
   with _ -> raise InvalidInputException
) in
let valid = match valid with
    | '0' -> false
    | '1' -> true
    | _ -> raise InvalidInputException in
let value = match value with
    | v when (v >= 0 && v <= 1023) -> v
    | _ -> raise InvalidInputException in
(valid, value)

let string_of_couple arg = 
match arg with
| v, c -> Printf.sprintf "%d %s" c (string_of_bool v)

let voteur_input () = 
	let res = Array.make 3 (false, 0) in
	for i = 0 to 2 do
		res.(i) <- 
			try voteur_input_line stdin
			with _ -> (false, 0)
	done;
	Printf.printf "%s - %s - %s == %s\n"
		(string_of_couple res.(0))
		(string_of_couple res.(1))
		(string_of_couple res.(2))
		(string_of_couple 
			(voteur (snd res.(0)) (fst res.(0))
				(snd res.(1)) (fst res.(1))
				(snd res.(2)) (fst res.(2))
			)
		)

let _ =
 voteur_input ()
