/*
 * Decompiled with CFR 0.152.
 */
package parsers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class JsonToXml {
    public static void parsePaire(Map.Entry<String, JsonElement> pair) {
        System.out.println("<item name='" + pair.getKey() + "'>");
        System.out.println("\t");
        if (pair.getValue().isJsonPrimitive()) {
            JsonToXml.parsePrimitive(pair.getValue().getAsJsonPrimitive());
        } else if (pair.getValue().isJsonNull()) {
            JsonToXml.parseNull(pair.getValue().getAsJsonNull());
        } else if (pair.getValue().isJsonObject()) {
            JsonToXml.parseObject(pair.getValue().getAsJsonObject());
        } else if (pair.getValue().isJsonArray()) {
            JsonArray array = pair.getValue().getAsJsonArray();
            JsonToXml.parseArray(array);
        }
        System.out.println("</item>");
    }

    private static void parseArray(JsonArray array) {
        if (array.size() == 0) {
            System.out.println("<array/>");
        } else {
            System.out.println("<array>");
            System.out.println("\t");
            for (JsonElement element : array) {
                JsonToXml.parse(element);
            }
            System.out.println("</array>");
        }
    }

    private static void parseNull(JsonNull asJsonNull) {
        System.out.println("<null/>");
    }

    private static void parsePrimitive(JsonPrimitive asJsonPrimitive) {
        if (asJsonPrimitive.isNumber()) {
            System.out.println("<number>" + asJsonPrimitive.getAsNumber() + "</number>");
        } else if (asJsonPrimitive.isBoolean()) {
            System.out.println("<" + asJsonPrimitive.getAsBoolean() + "/>");
        } else if (asJsonPrimitive.isString()) {
            System.out.println("<string>" + asJsonPrimitive.getAsString() + "</string>");
        }
    }

    public static void parseObject(JsonObject object) {
        System.out.println("<object>");
        System.out.println("\t");
        for (Map.Entry pair : object.entrySet()) {
            JsonToXml.parsePaire(pair);
        }
        System.out.println("</object>");
    }

    public static void parse(JsonElement element) {
        if (element.isJsonObject()) {
            JsonToXml.parseObject(element.getAsJsonObject());
        } else if (element.isJsonArray()) {
            JsonToXml.parseArray(element.getAsJsonArray());
        } else if (element.isJsonPrimitive()) {
            JsonToXml.parsePrimitive(element.getAsJsonPrimitive());
        } else if (element.isJsonNull()) {
            JsonToXml.parseNull(element.getAsJsonNull());
        }
    }
}

