type 'a t = {
  the_width : int;
  the_height : int;
  the_contents : 'a array
}

let make w h x =
  {
    the_width = w;
    the_height = h;
    the_contents =  Array.make (w*h) x
  }

exception OutOfBounds of (int * int)

let width tab = tab.the_width

let height tab = tab.the_height

let get tab (lig, col) =
  try
    tab.the_contents.(lig*tab.the_width + col) 
  with
      Invalid_argument "index out of bounds" -> raise (OutOfBounds (lig,col))

let set tab (lig,col) v =
  try
    tab.the_contents.(lig*tab.the_width+col) <- v
  with
      Invalid_argument "index out of bounds" -> raise (OutOfBounds (lig,col))
      
