type cell = Token | Empty

let _W = 5
let _EmptyPos = (2,2)

let gameBoard = Grid.make _W _W Empty

let getWidth() = Grid.width gameBoard

let getHeight() = Grid.height gameBoard

let init () =
  for row=0 to _W-1 do
    for col=0 to _W-1 do
      Grid.set gameBoard (row,col) Token
    done
  done;
  Grid.set gameBoard _EmptyPos Empty
    
let empty pos =
  (Grid.get gameBoard pos) = Empty
  
let print () =
  for row=0 to (getHeight())-1 do
    for col=0 to (getWidth())-1 do
      if (empty (row,col)) then
	print_char '.'
      else
	print_char 'o'
    done;
    print_char '\n'
  done

type move = Stay | Up | Down | Left | Right

let nextPos mv pos =
  let row,col = pos in
    match mv with
	Up -> (row-1, col)
      | Down -> (row+1, col)
      | Left -> (row, col-1)
      | Right -> (row, col+1)
      | Stay -> pos
    
let checkMoveDir pos mv =
  let pos' = nextPos mv pos in
  let pos'' = nextPos mv pos' in
    try
      if (not (empty pos) && not (empty pos') && (empty pos'')) then
	mv
      else
	Stay
    with _ -> Stay

let checkMoveTo ((row1,col1) as pos1) (row2,col2) =
  if (row1=row2) then
    if (col2=col1-2) then (checkMoveDir pos1 Left)
    else if (col2=col1+2) then (checkMoveDir pos1 Right)
    else Stay
  else if (col1=col2) then
    if (row2=row1-2) then (checkMoveDir pos1 Up)
    else if (row2=row1+2) then (checkMoveDir pos1 Down)
    else Stay
  else Stay

(*
Hypothèse: le mouvement est légal
*)
let doMove dir pos =
  let pos' = nextPos dir pos in
  let pos'' = nextPos dir pos' in
    Grid.set gameBoard pos Empty;
    Grid.set gameBoard pos' Empty;
    Grid.set gameBoard pos'' Token
     
	
	
