let w = 50
let r = (w/2)-2
let r0 = 5
let x0 = w/2
let y0 = x0
let pxw = w * (Model.getWidth())
let pxh = w * (Model.getHeight())

type state = {
  mutable srcSelected : bool;
  mutable srcPos : int*int;
}

let theState =
  {
    srcSelected = false;
    srcPos = (0,0);
  }

let init () =
  theState.srcSelected <- false;
  Graphics.open_graph (Printf.sprintf" %dx%d" (w+pxw) (w+pxh))

let draw_background () =
  Graphics.set_color Graphics.white;
  Graphics.fill_rect x0 y0 pxw pxh;
  Graphics.set_color Graphics.blue;
  Graphics.draw_rect x0 y0 pxw pxh;
  Graphics.set_color Graphics.black
  
let draw () =
  draw_background();
  for row= (Model.getHeight())-1 downto 0 do
    for col=0 to (Model.getWidth())-1 do
      if (Model.empty (row,col)) then
	Graphics.draw_circle ((col+1)*w) ((row+1)*w) r0
      else (
	if (theState.srcSelected && theState.srcPos = (row,col)) then 
	  Graphics.set_color Graphics.green;
	Graphics.draw_circle ((col+1)*w) ((row+1)*w) r;
	Graphics.set_color Graphics.black
      ) 
    done
  done
    
let pos_of x y = (((y-y0)/w), (x-x0)/w)

exception Exit
  
let rec loop () =
  draw();
  let gs =
    Graphics.wait_next_event
      [Graphics.Button_down; Graphics.Key_pressed]
  in
    if gs.Graphics.button then (
      let x = gs.Graphics.mouse_x
      and y = gs.Graphics.mouse_y in
      let pos = pos_of x y in
	if not (Model.empty pos) then (
	  theState.srcPos <- pos;
	  theState.srcSelected <- true
	)
	else (
	  match Model.checkMoveTo theState.srcPos pos with
	      Model.Stay -> (
		theState.srcSelected <- false
	      )
	    | dir -> (
		Model.doMove dir theState.srcPos;
		theState.srcSelected <- false;
	      )
	);
	loop ()
    )
    else if (gs.Graphics.keypressed) then
      if (gs.Graphics.key = 'q') then
	raise Exit

