(* ================================================================== *)
(* == POD 98-99 --                                                    *)
(* ------------------------------------------------------------------ *)
(* == Client/Serveur via Internet : Hello v.01                        *)
(* La version de base du client                                       *)
(* ------------------------------------------------------------------ *)
(*   ocamlc -custom unix.cma hello1.ml -o hello1 -cclib -lunix        *)
(* ================================================================== *)

open Unix
;;

(* == val get_in_addr : string -> Unix.inet_addr                      *)
(* Calcule l'adresse IP du serveur en fonction de son argument        *)
let get_in_addr host = 
 try 
  (* on essaie 'machine.domaine' *)
  (gethostbyname host).h_addr_list.(0)
 with 
  Not_found 
  -> try 
      (* sinon : x.y.z.w *)
      inet_addr_of_string host       
     with
      Failure "inet_addr_of_string" -> failwith("unknown host "^host)
;;

(* == val get_s_port : string -> int                                  *)
(* Calcule le numero de port du service en fonction de son argument   *)
let get_s_port port =
 try int_of_string port with
  Failure("int_of_string") -> failwith("incorrect port number "^port)
;;

(* == val client : unit -> unit                                       *)
(* Le client                                                          *)
let client () =
 (* Si pas assez d'arguments : erreur    *)
 if Array.length Sys.argv < 3 then
   begin
    Printf.eprintf "Usage : hello1 hostname portnumber\n"
   end
 (* sinon *)
 else
  (* Adresse du serveur (1ier argument) *)
  let in_addr = get_in_addr Sys.argv.(1) in
  (* Port de connexion (2nd argument) *)
  let s_port = get_s_port Sys.argv.(2) in
  (* Creation de la socket de service *)
  let sock = socket PF_INET SOCK_STREAM 0 in
   begin
    (* Connexion *)
    connect sock (ADDR_INET(in_addr, s_port));
     (* Lecture et affichage de la reponse *)
     let r = input_line (in_channel_of_descr sock) in
      Printf.printf "(%d) %s\n" (String.length r) r;
      flush (out_channel_of_descr stdout)
   end
;;

(* == Programme principal *)
try
 client()
with
 Unix_error(c,f,x)
 -> Printf.eprintf "\n %s in %s %s\n" (error_message c) f x
;;
