(* ================================================================== *)
(* == POD 98-99 --                                                    *)
(* ------------------------------------------------------------------ *)
(* == Client/Serveur via Internet : Hello v.02                        *)
(* La version du serveur avec attente d'acquitement                   *)
(* ------------------------------------------------------------------ *)
(*   ocamlc -custom unix.cma hello2d.ml -o hello2d -cclib -lunix      *)
(* ================================================================== *)

open Unix
;;

(* == val get_s_port : string -> int                                  *)
(* Calcule le numero de port du service en fonction de son argument   *)
let get_s_port p_num =
 try int_of_string p_num with
  Failure("int_of_string") -> failwith("incorrect port number "^p_num)
;;

(* == val message : Unix.sockaddr -> string                           *)
(* Compose le message de reponse a la connection d'un client          *)
let message = function
 ADDR_UNIX _ -> "\n Hum, something's strange with this UNIX socket\n"
|ADDR_INET(cl_inet_addr,_)
 -> ("Hello "^((gethostbyaddr cl_inet_addr).h_name)
    ^" ("^(string_of_inet_addr cl_inet_addr)^")\n")
;;

(* == val server : unit -> unit                                       *)
(* Le serveur                                                         *)
let server () =
 (* Si pas d'argument : erreur    *)
 if Array.length Sys.argv < 2 then
   begin
    Printf.eprintf "Usage : hello2d portnumber\n"
   end
 (* sinon *)
 else
  (* Lecture du numero de port du service *)
  let port = get_s_port Sys.argv.(1) in
  (* Creation de la socket de service *)
  let sock = socket PF_INET SOCK_STREAM 0 in
  (* Adresse du serveur *)
  let h_addr = (gethostbyname (gethostname())).h_addr_list.(0) in
  (* Adresse de la socket *)
  let sock_addr = ADDR_INET(h_addr, port) in
   begin
    (* Liaison socket/adresse *)
    bind sock sock_addr;
    (* Mise en attente de connection *)
    listen sock 5;
    (* Boucle de service *)
    while true do
     (* On accepte une connexion *)
     let (cl_sock, cl_sock_addr) = accept sock in
      (* On cree un processus de traitement de la connexion (le fils) *)
      if fork() == 0 then
       begin
        (* Hack Unix :-) *)
        if fork()<>0 then exit 0;
        (* Emission du message de reponse *)
        (let m = message cl_sock_addr in
          write cl_sock m 0 (String.length m));
        (* Lecture de l'acquitement *)
        (let r = String.make 2 '\000' in
          read cl_sock r 0 2);
        (* Fermeture de la socket client *)
        close cl_sock;
        (* Fin du processus de traitement de connexion *)
        exit 0
       end
      else (* Le pere *)
       (* Attente fin de traitement connexion (par le fils) *)
       let _ = wait() in close cl_sock
     done
    end
;;

(* == Programme principal *)
try
 server()
with
 Unix_error(c,f,x)
 -> Printf.eprintf "\n %s in %s %s\n" (error_message c) f x
|Failure x
 -> Printf.eprintf "\n %s \n" x
;;


