#Marmote and MarmoteMDP and pyMarmoteMDP are free softwares: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.

#Marmote is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with MarmoteMDP. If not, see <http://www.gnu.org/licenses/>.

#Copyright 2019 Emmanuel Hyon, Alain Jean-Marie
 
from pyMarmoteMDP import *

"""
 @brief An example to enumerate a state space of two dimensions
 @author Hyon, Lip6
 @date Jul 2020
 @version 1.2
 
 Cet exemple de test fait créer un ensemble à deux dimensions marmoteBox
 
 Un marmotebox est un espace multidimensionnels dont chacune des dimensions peut avoir une taille differente
 
 
 On illustre le fonctionnement de cet objet marmoteBox en parcourant l'espace d'état
 
 On introduit aussi deux fonctions pour plus de lisibilité
 
 getEtat(param1,param2) permet de recuperer la valeur de la case d'indice param2 du tableau param1  

  setEtat(param1,param2,param3) permet de donner la valeur param3 a la case d'indice param2 
  pour le tableau donne en param1
  
  La derniere enumaration fait enumerer l ensemble en suivant une dimension
  
  les fonctions qui finissent par outDim font varier les valeurs 
  sans toucher à la dimension qu on cherche à explorer
  
  les fonctions qui finissent par byDim ne touchent qu'a la dimension qu'on cherche à explorer
 
"""
  
def getEtat(etat,i):
    return intTab_getitem(etat,i)

def setEtat(etat,i,val):
    intTab_setitem(etat,i,val)


#suite d'instructions pour creer un ensemble marmoteBox pour l'espace d'etat
#je cree dims un tableau d'entiers de taille 2 (pour faire le passage avec le C++)
# ces tableau ne sont pas des tableaux numpy
dims=new_intTab(2)
# l instruction intTab_setitem permet d'affecter des valeurs au tableau
#ici je donne au tableau dims le valeur 5 pour la case 0 et la valeur 2 pour la case d'indice 1
intTab_setitem(dims,0,5)
intTab_setitem(dims,1,2)
"""
le tableau dims donne dans sa premiere dimension la taille de la premiere dimension de la box 
et dans sa seconde  dimension la taille de la second dimension de la box

Ici on est dans un espace qui est une boite de taille 5*2
"""
#creation des espace d etat par la creation de l'objet marmoteBox
stateSpace=marmoteBox(2,dims)

# un ensemble marmoteBox pour l'espace d'action (meme type d'isntructions)
dima=new_intTab(2)
intTab_setitem(dima,0,2)
intTab_setitem(dima,1,4)
actionSpace = marmoteBox(2,dima)


  
#enumerating by hands of the state space
#creation du tableau qui stocke l etat
# en effet une variable etat stocke l'etat mutlidimensionnel
# a chaque etat est associé un indice
etat=new_intTab(2)
# le etat va etre [0,0]
intTab_setitem(etat,0,0)
intTab_setitem(etat,1,0)

print("First enumerating")
# I define etat as the first one of the state space
stateSpace.firstState(etat)
for i in range(stateSpace.cardinal()) :   
    # I get the index of the current state
    index=stateSpace.index(etat)
    # I put the first coordinate of the state in x
    x=intTab_getitem(etat,0)
    # I put the second coordinate of the state in j
    j=intTab_getitem(etat,1)
    # I print the index and the two values of the state associated with the index
    print("state : (",x,",",j,")")
    # I jump to the following state
    stateSpace.nextState(etat)
    
print("end of the state space enumerating\n")

#enumerating by hand the action space
# we use now the fonction getEtat
# the framework the same than in the previous enumerating
print("action space enumerating")
actionSpace.firstState(etat)
for i in range(actionSpace.cardinal()):
    # I get the index of the current state
    index=actionSpace.index(etat)
    # I put the first coordinate of the state in x
    x=getEtat(etat,0)
    # I put the second coordinate of the state in j
    j=getEtat(etat,1)
    # I print the index and the two values of the state associated with the index
    print("Action Space  state : (",x,",",j,")") 
    # I jump to the following state
    actionSpace.nextState(etat)
print("end of the action space enumerating\n")

#enumerating by hand the action space
# It is possible to enumerate by following a dimension
dime=0;
print("Begining of the enumerating w.r.t. dimension=",dime);
actionSpace.firstState(etat)
actionSpace.firstStateOutDim(etat,dime);
for i in range(actionSpace.cardinalOutDim(dime)) :
        #enumerating following the dimension
        indice=actionSpace.index(etat)
        x=intTab_getitem(etat,0)
        y=intTab_getitem(etat,1)
        print("Indice: ",indice," etat : (",x,",",y,")")
        # I put the state to the first state of the dimension dime
        actionSpace.firstStatebyDim(etat,dime)
        for  j in range(actionSpace.cardinalbyDim(dime)) :
          indice=actionSpace.index(etat)
          x=intTab_getitem(etat,0)
          y=intTab_getitem(etat,1)
          print("--Indice: ",indice," etat : (",x,",",y,")")
          actionSpace.nextStatebyDim(etat,dime)
        print("")
        actionSpace.nextStateOutDim(etat,dime)
       
print("Ending of the enumerating w.r.t. dimension=",dime)
print("\n")

