#!/usr/bin/env python3
# -*- coding: utf-8 -*-

#Marmote and MarmoteMDP and pyMarmoteMDP are free softwares: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.

#Marmote is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY  without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#GNU General Public License for more details.

#You should have received a copy of the GNU General Public License
#along with MarmoteMDP. If not, see <http://www.gnu.org/licenses/>.

#Copyright 2019 Emmanuel Hyon, Alain Jean-Marie
"""
 @brief An example to enumerate a state space of two dimensions
 @author Hyon, Lip6
 @date Nov 2020
 @version 1.1
 
 This exemple is the code for building an finite Horizon Disounted model.
 
 This exemple is this one used in the course 

"""
from pyMarmoteMDP import *

beta=1
critere = "min"
N=4 

#initialize epsilon unused but only here for compatiblity
epsilon = 0.0001  
#Initialize maximum number of iterations unused only here for compatiblity
maxIter = 700

 
#Create the MDP object to test 1-dimension example and fill all its fields.
min = 1 
max = 3 
actionSpace =  marmoteInterval(0,3) 
stateSpace =   marmoteInterval(min,max) 

transl=list()

P = sparseMatrix(stateSpace.cardinal()) 
  
P.addToEntry(0,0,0.25) 
P.addToEntry(0,1,0.5) 
P.addToEntry(0,2,0.25)   
P.addToEntry(1,0,0.5) 
P.addToEntry(1,1,0.25) 
P.addToEntry(1,2,0.25) 
P.addToEntry(2,0,0.4) 
P.addToEntry(2,1,0.2) 
P.addToEntry(2,2,0.4) 
  
transl.append(P) 

  
P = sparseMatrix(stateSpace.cardinal()) 
P.addToEntry(0,0,0.6) 
P.addToEntry(0,1,0.2) 
P.addToEntry(0,2,0.2) 
P.addToEntry(1,0,0.4) 
P.addToEntry(1,1,0.3) 
P.addToEntry(1,2,0.3) 
P.addToEntry(2,0,0.5) 
P.addToEntry(2,1,0.4) 
P.addToEntry(2,2,0.1) 
transl.append(P) 
  
P =  sparseMatrix(stateSpace.cardinal()) 
P.addToEntry(0,0,0.25) 
P.addToEntry(0,1,0.55) 
P.addToEntry(0,2,0.2) 
P.addToEntry(1,0,0.1) 
P.addToEntry(1,1,0.2) 
P.addToEntry(1,2,0.7) 
P.addToEntry(2,0,0.2) 
P.addToEntry(2,1,0.4) 
P.addToEntry(2,2,0.4) 
transl.append(P) 
  
P =  sparseMatrix(stateSpace.cardinal()) 
P.addToEntry(0,0,0.0) 
P.addToEntry(0,1,0.1) 
P.addToEntry(0,2,0.9) 
P.addToEntry(1,0,0.3) 
P.addToEntry(1,1,0.4) 
P.addToEntry(1,2,0.3) 
P.addToEntry(2,2,1) 
transl.append(P) 

trans=sparseMatrixVector(actionSpace.cardinal())
for i in range(len(transl)):
    trans[i]=transl[i]

R  =  sparseMatrix(stateSpace.cardinal(),actionSpace.cardinal()) 
R.addToEntry(0,0,3.025) 
R.addToEntry(0,1,0.225) 
R.addToEntry(0,2,2.07) 
R.addToEntry(0,3,0.77) 
R.addToEntry(1,0,4.24) 
R.addToEntry(1,1,1.22) 
R.addToEntry(1,2,1.44) 
R.addToEntry(1,3,-0.31) 
R.addToEntry(2,0,4.33) 
R.addToEntry(2,1,0.41) 
R.addToEntry(2,2,2.43) 
R.addToEntry(2,3,-0.4) 
  


print("Debut de la construction MDP\n") 
mdpfhd = finiteHorizonDiscountedMDP(critere, stateSpace, actionSpace, trans, R,N,beta) 
print("Fin de la construction MDP\n") 

print("Affichage MDP\n") 
mdpfhd.writeMDP() 


print("Affichage solution resolution par programmation dynamique\n") 
#call the function to solve the MDP.
optimum = mdpfhd.valueIteration() 
optimum.writeSolution() 
print("fin")