/* --------------------- */
/* --- macro_debug.h --- */
/* --------------------- */

#ifndef __MACRO_DEBUG_H__
#define __MACRO_DEBUG_H__

#ifdef __cplusplus
extern "C" {
#endif

// contrainte: n, x0, xstep, X et Y doivent etre connus
// reset des tableaux avec bords (WITH)
#define RESET_WITH  zero_f32vector(X, 0-b, n-1+b); zero_f32vector(Y, 0, n-1); init_param_f32vector(X, 0, n-1, x0, xstep);

// reset des tableaux sans bords (WITHOUT)
#define RESET_WITHOUT  zero_f32vector(X, 0, n-1); zero_f32vector(Y, 0, n-1);  init_param_f32vector(X, 0, n-1, x0, xstep);

#define BENCH(X, n, cpp)  do { double t0, t1, dt, tmin=1e20; int run = 5; int iter = 2; for(int r=0; r<run; r++) { t0=_rdtsc();  for(int k=0; k<iter; k++) { X; } t1=_rdtsc(); dt=t1-t0; dt /= (double)iter; if(dt<tmin) tmin = dt;} cpp = tmin/(n*n); } while(0)

// ENABLE_DEBUG : macro definissant le fonctionnement general des macros de debug
// si macro active, debug
// si macro inactive, release
//#define ENABLE_CONTROL : macro pour activer le controle d'acces

//#define ENABLE_DEBUG
//#define ENABLE_CONTROL
// ----------------------------------------------------- //
// -- be rien ecrire en desous de cette ligne ---------- //
// ----------------------------------------------------- //

#ifdef ENABLE_DEBUG

// macro de debug
#define LL_DEBUG(X) X

#define VERBOSE(X) X
#define PUTS(str) puts(str)
#define CR putchar('\n');

//#define add3(a, b, c) a+b+c; printf("%.0f + %.0f + %.0f = %.0f\n", a, b, c, a+b+c)
#define add2(a, b) a+b
#define add3(a, b, c) a+b+c
#define add9(x0,x1,x2,x3,x4,x5,x6,x7,x8) add3(x0,x1,x2)+add3(x3,x4,x5)+add3(x6,x7,x8)

#define idisp(x) printf("%s = %3d\n", #x, x)
#define disp(x) printf("%s = %5.0f\n", #x, x)

// --------------------------
// -- premier niveau de debug
// --------------------------
#ifndef ENABLE_CONTROL
// A COMPLETER
// les macros contiennent un code par defaut qu'il faut changer
// objectif: realiser la fonction et faire un affichage
#define load1(X, i) X[i]
#define store1(Y, i, y) Y[i]=y

#define load2(X, i, j) X[i][j]
#define store2(Y, i, j, y) Y[i][j]=y
#endif
// ---------------------------
// -- deuxieme niveau de debug
// ---------------------------
#ifdef ENABLE_CONTROL

// A COMPLETER
// les macros contiennent un code par defaut qu'il faut changer
// objectif: realiser la fonction et faire un controle d'acces et afficher un message d'erreur si besoin

#define load1(X, i) X[i]
#define store1(Y, i, y) Y[i]=y

#define load2(X, i, j) X[i][j]
#define store2(Y, i, j, y) Y[i][j]=y

#endif

#else

#define idisp(x)
#define disp(x)

#define LL_DEBUG(X)
#define VERBOSE(X)
#define PUTS(str)
#define CR
#define load1(X, i) X[i]
#define store1(Y, i, y) Y[i]=y

#define load2(X, i, j) X[i][j]
#define store2(Y, i, j, y) Y[i][j]=y

#define add2(a, b) a+b
#define add3(a, b, c) a+b+c
#define add9(x0,x1,x2,x3,x4,x5,x6,x7,x8) add3(x0,x1,x2)+add3(x3,x4,x5)+add3(x6,x7,x8)

#endif // ENABLE_DEBUG

#ifdef __cplusplus
}
#endif

#endif // __MACRO_DEBUG_H__
