/* ----------------------- */
/* --- stencil2_with.h --- */
/* ----------------------- */

/*
 * Copyright (c) 2020 - 2021 Lionel Lacassagne, All rights reserved
 * LIP6, Sorbonne University, CNRS
 */

#ifndef __STENCIL2_WITH_H__
#define __STENCIL2_WITH_H__

#ifdef __cplusplus
#ifdef PRAGMA_VERBOSE
#pragma message ("C++")
#endif
extern "C" {
#endif

// line functions
void line_add3_f32matrix_basic               (float32 **X, int i, int j0, int j1, float32 **Y);
void line_add3_f32matrix_reg                 (float32 **X, int i, int j0, int j1, float32 **Y);
void line_add3_f32matrix_rot                 (float32 **X, int i, int j0, int j1, float32 **Y);
void line_add3_f32matrix_red                 (float32 **X, int i, int j0, int j1, float32 **Y);
void line_add3_f32matrix_ilu3                (float32 **X, int i, int j0, int j1, float32 **Y);
void line_add3_f32matrix_ilu3_red            (float32 **X, int i, int j0, int j1, float32 **Y);
void line_add3_f32matrix_elu2_red            (float32 **X, int i, int j0, int j1, float32 **Y);
void line_add3_f32matrix_elu2_red_factor     (float32 **X, int i, int j0, int j1, float32 **Y);
void line_add3_f32matrix_ilu3_elu2_red_factor(float32 **X, int i, int j0, int j1, float32 **Y);
    
// full-matrix functions
void add3_f32matrix_basic               (float32 **X, int i0, int i1, int j0, int j1, float32 **Y);
void add3_f32matrix_reg                 (float32 **X, int i0, int i1, int j0, int j1, float32 **Y);
void add3_f32matrix_rot                 (float32 **X, int i0, int i1, int j0, int j1, float32 **Y);
void add3_f32matrix_red                 (float32 **X, int i0, int i1, int j0, int j1, float32 **Y);
void add3_f32matrix_ilu3                (float32 **X, int i0, int i1, int j0, int j1, float32 **Y);
void add3_f32matrix_ilu3_red            (float32 **X, int i0, int i1, int j0, int j1, float32 **Y);
void add3_f32matrix_elu2_red            (float32 **X, int i0, int i1, int j0, int j1, float32 **Y);
void add3_f32matrix_elu2_red_factor     (float32 **X, int i0, int i1, int j0, int j1, float32 **Y);
void add3_f32matrix_ilu3_elu2_red_factor(float32 **X, int i0, int i1, int j0, int j1, float32 **Y);

// standalone functions
void add3_f32matrix_sep0(float32 **X, int i0, int i1, int j0, int j1, float32 **Y, float32 **T);
void add3_f32matrix_sep1(float32 **X, int i0, int i1, int j0, int j1, float32 **Y, float32 **T);

#ifdef __cplusplus
}
#endif

#endif // __STENCIL2_WITH_H__
