/* ================= */
/* === stencil.c === */
/* ================= */

// stencil 1D

#include <stdio.h> // pour affichage
#include <stdlib.h>
#include <math.h>

#include "nrdef.h"
#include "nrutil.h"

//#include "stencil.h"
#include "macro_debug.h"
// ----------------------------------
void init_X(float *X, int i0, int i1)
// ----------------------------------
{
    for(int i = i0; i <= i1; i++) {
        //X[i] = i + 10;
        X[i] = i + 1;
    }
}
// -----------------------------------------------------------------------
void init_param_f32vector(float *X, int i0, int i1, float x0, float xstep)
// -----------------------------------------------------------------------
{
    for(int i = i0; i <= i1; i++) {
        X[i] = x0 + i * xstep;
    }
}
// -------------------------------------------------------------------------------------------------------
void init_param_f32matrix(float **X, int i0, int i1, int j0, int j1, float x0, float xstep, float32 ystep)
// -------------------------------------------------------------------------------------------------------
{
    for(int i = i0; i <= i1; i++) {
        for(int j = j0; j <= j1; j++) {
            X[i][j] = x0 + i * ystep + j * xstep;
        }
    }
}
// -----------------------------
int clamp(int i, int i0, int i1)
// -----------------------------
{
    if(i < i0) return i0;
    if(i > i1) return i1;
    return i;
}
// -----------------------------
int is_in(int i, int i0, int i1)
// -----------------------------
{
    if( (i >= i0) && (i <= i1)) return 1;
    return 0;
}
// -----------------------------------------------------------------------
int check_param_f32vector(float *Y, int i0, int i1, float x0, float xstep)
// -----------------------------------------------------------------------
{
    // A COMPLETER
    return 0;
}
// -------------------------------------------------------------
int check_param(float *Y, int i0, int i1, float x0, float xstep)
// -------------------------------------------------------------
{
    //return 1;
    return check_param_f32vector(Y, i0, i1, x0, xstep);
}
// -----------------------------------------------------------------------------------------------------
int check_param_f32matrix(float **Y, int i0, int i1, int j0, int j1, float x0, float xstep, float ystep)
// -----------------------------------------------------------------------------------------------------
{
    // A COMPLETER
    return 0; // OK
}
// -------------------------------------------------------------------------------------
void verbose_check_f32vector(float *X, int i0, int i1, float x0, float xstep, char* str)
// -------------------------------------------------------------------------------------
{
    if(check_param_f32vector(X, i0, i1, x0, xstep)) {
        printf("[check]: %s is OK\n", str);
    } else {
        printf("[check]: %s is buggy ####################\n", str);
    }
}
// -------------------------------------------------------------------------------------------------------------------
void verbose_check_f32matrix(float **X, int i0, int i1, int j0, int j1, float x0, float xstep, float ystep, char* str)
// -------------------------------------------------------------------------------------------------------------------
{
    if(check_param_f32matrix(X, i0, i1, j0, j1, x0, xstep, ystep)) {
        printf("[check]: %s is OK\n", str);
    } else {
        printf("[check]: %s is buggy ####################\n", str);
    }
}
// ----------------------------------------------------------------------
int compare_f32vector(float32 *X, int i0, int i1, float32 *Y, char* name)
// ----------------------------------------------------------------------
{
    int c = 0;
    
    for(int i=i0; i<=i1; i++) {
        if(fabs(X[i] - Y[i]) > 1e-6) {
            printf("%s [%3d] = %5.0f NEQ %5.0f\n", name, i, X[i], Y[i]);
            c++;
        }
    }
    if(c) {
        printf("[compare]: %d errors !\n", c); exit(-1);
    } else {
        printf("[compare]: %s is OK\n", name);
        return c;
    }
    puts("----------------------");
}
// ----------------------------------------------------------------------------------------
int compare_f32matrix(float32 **X, int i0, int i1, int j0, int j1, float32 **Y, char* name)
// ----------------------------------------------------------------------------------------
{
    int c = 0;
    
    //display_ui8matrix(Y, i0, i1, j0, j1, "%5d", name);
    
    for(int i=i0; i<=i1; i++) {
        for(int j=j0; j<=j1; j++) {
            if(fabs(X[i][j] - Y[i][j]) > 1e-6) {
                printf("%s [%3d][%3d] = %5.0f NEQ %5.0f\n", name, i, j, X[i][j], Y[i][j]);
                c++;
            }
        }
    }
    if(c) {
        printf("[compare]: %d errors !\n", c); exit(-1);
    } else {
        printf("[compare]: %s is OK\n", name);
        return c;
    }
    puts("----------------------");
}
