/* ============================ */
/* === test_stencil1_with.c === */
/* ============================ */


#include <stdio.h> // pour affichage
#include <stdlib.h>
#include <math.h>

#include "nrdef.h"
#include "nrutil.h"
#include "stencil.h"
#include "stencil1_with.h"
#include "macro_debug.h"

// ======================
int main_add3_with(int n)
// ======================
{
    PUTS("====================");
    PUTS("== main_add3_with ==");
    PUTS("====================");
    
    int b = 1; // bord
    float x0, xstep; // parametres d'initisation
    
    // configurations d'init
    x0 = 0; xstep = 1;
    //x0 = 1; xstep = 2;
    
    puts("----------------------------------------------");
    printf("n = %d => output Y[%d .. %d]  input X[%d .. %d]\n", n, 0,n-1, 0,n-1);
    
    float *X = f32vector(0 - b, n - 1 + b); // alloc avec bords
    float *Y = f32vector(0,     n - 1);     // alloc sans bord
    
    zero_f32vector(X, 0 - b, n - 1 + b);
    // init avec intialisation des bords a zero
    
    //init_X(X, 0 - b, n - 1 + b);
    //display_f32vector(X, 0, n-1, "%5.0f", "X0    "); putchar('\n');
    
    // init sans initialisation des bords qui contienne zero
    // c'est a la fonction de le faire ...
    init_param_f32vector(X, 0, n-1, x0, xstep);
    
    //display_f32vector(X, 0 - b, n-1 + b, "%5.0f", "Xb ");
    //display_f32vector(X, 0, n-1, "%5.0f", "X     "); putchar('\n');
    
    RESET_WITH;
    display_f32vector(X, 0, n-1, "%5.0f", "X      ");
    add3_bas(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "BAS    ");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "BAS    "); CR;
    
    RESET_WITH;
    display_f32vector(X, 0, n-1, "%5.0f", "X      ");
    add3_reg(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "REG    ");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "REG    "); CR;
        
    RESET_WITH;
    display_f32vector(X, 0, n-1, "%5.0f", "X      ");
    add3_rot(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "ROT    ");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "ROT    "); CR;
    
    RESET_WITH;
    display_f32vector(X, 0, n-1, "%5.0f", "X      ");
    add3_lu3(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "LU3    ");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "LU3    ");
    
    RESET_WITH;
    display_f32vector(X, 0, n-1, "%5.0f", "X      ");
    add3_sp3(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "SP3    ");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "SP3    ");
    
    RESET_WITH;
    display_f32vector(X, 0, n-1, "%5.0f", "X      ");
    add3_sp2(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "SP2    ");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "SP2    ");
    
    RESET_WITH;
    display_f32vector(X, 0, n-1, "%5.0f", "X      ");
    add3_sp_rot2(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "SP_ROT2");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "SP_ROT2");
    
    RESET_WITH;
    display_f32vector(X, 0, n-1, "%5.0f", "X      ");
    add3_sp_lu2(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "SP_LU2 ");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "SP_LU2 ");
            
    free_f32vector(X, 0 - b, n - 1 + b); // alloc avec bords
    free_f32vector(Y, 0,     n - 1);     // alloc sans bord
    return 0;
}

// ==================================================
int main_stencil1_with(int argc, const char * argv[])
// ==================================================
{
    puts("----------------------");
    puts("-- add3 with border --");
    puts("----------------------");
    
    main_add3_with(6+0);
    //main_add3_with(6+1);
    //main_add3_with(6+2);
    //main_add3_with(6+3);
    
    return 0;
}
