/* =============================== */
/* === test_stencil1_without.c === */
/* =============================== */


#include <stdio.h> // pour affichage
#include <stdlib.h>
#include <math.h>

#include "nrdef.h"
#include "nrutil.h"
#include "stencil.h"
#include "stencil1_without.h"
#include "macro_debug.h"

//#include "ia32intrin.h"
//#include "x86intrin.h"

// =========================
int main_add3_without(int n)
// =========================
{
    PUTS("=======================");
    PUTS("== main_add3_without ==");
    PUTS("=======================");
    
    float x0, xstep; // parametres d'initisation
    
    // configurations d'init
    x0 = 0; xstep = 1;
    //x0 = 1; xstep = 2;
    //x0 = 10; xstep = 3;
    
    puts("----------------------------------------------");
    printf("n = %d => output Y[%d .. %d]  input X[%d .. %d]\n", n, 0,n-1, 0,n-1);
    
    float *X = f32vector(0, n-1); // alloc SANS bords
    float *Y = f32vector(0, n-1); // alloc SANS bords
    
    zero_f32vector(X, 0, n-1);
    zero_f32vector(Y, 0, n-1);
    
    init_param_f32vector(X, 0, n-1, x0, xstep);
    
    //display_f32vector(X, 0 , n-1, "%5.0f", "X     ");
    
    PUTS("add3_basic0_without"); RESET_WITHOUT;
    display_f32vector(X, 0 , n-1, "%5.0f", "X     ");
    add3_basic0_without(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "BAS0  ");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "BAS0  "); CR;
    
    PUTS("add3_basic1_without"); RESET_WITHOUT;
    display_f32vector(X, 0 , n-1, "%5.0f", "X     ");
    add3_basic1_without(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "BAS1  ");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "BAS1  "); CR;
    
    PUTS("add3_reg_without"); RESET_WITHOUT;
    display_f32vector(X, 0 , n-1, "%5.0f", "X     ");
    add3_rot_without(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "REG   ");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "REG   "); CR;
    
    PUTS("add3_rot_without"); RESET_WITHOUT;
    display_f32vector(X, 0 , n-1, "%5.0f", "X     ");
    add3_rot_without(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "ROT   ");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "ROT   "); CR;
    
    // super complexe
    PUTS("add3_sp3_without"); RESET_WITHOUT;
    display_f32vector(X, 0 , n-1, "%5.0f", "X     ");
    add3_sp3_without(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "SP3   ");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "SP3   "); CR;
    
    PUTS("add3_sp2_without"); RESET_WITHOUT;
    display_f32vector(X, 0 , n-1, "%5.0f", "X     ");
    add3_sp2_without(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "SP2   ");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "SP2   "); CR;
    
    // hyper complexe
    PUTS("add3_sp_rot2_without"); RESET_WITHOUT;
    display_f32vector(X, 0 , n-1, "%5.0f", "X     ");
    add3_sp_rot2_without(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "SP_ROT");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "SP_ROT"); CR;
    
    // encore plus difficile
    PUTS("add3_sp_lu2_without"); RESET_WITHOUT;
    display_f32vector(X, 0 , n-1, "%5.0f", "X     ");
    add3_sp_lu2_without(X, n, Y);
    display_f32vector(Y, 0, n-1, "%5.0f", "SP_LU2");
    verbose_check_f32vector(Y, 0, n-1, x0, xstep, "SP_LU2"); CR;
    
    free_f32vector(X, 0, n-1);
    free_f32vector(Y, 0, n-1);
    return 0;
}
// =====================================================
int main_stencil1_without(int argc, const char * argv[])
// =====================================================
{
    puts("-------------------------");
    puts("-- add3 without border --");
    puts("-------------------------");

    main_add3_without(6+0);
    //main_add3_without(6+1);
    //main_add3_without(6+2);
    
    
    return 0;
}
