
%{
  open Mltype;;

%}

%token EOF
%token <int> INT
%token <string> VAR
%token <float> FLOAT
%token <string> STRING
%token APP
%token FUN
%token LET
%token PLUS
%token MINUS
%token COMA
%token TIMES
%token DIV
%token REM
%token POINT
%token LET
%token REC
%token OPP
%token LESS
%token EQUAL
%token TUPLE
%token PROJ
%token IF
%token ELSE
%token THEN
%token CALL_CC
%token SEMISEMI
%token TO
%token EQ
%token SEMI
%token COLON
%token LPAR
%token RPAR
%token IN
%token COLONCOLON
%token LCR
%token RCR
%token LP
%token RP
%token FALSE
%token TRUE
%token CHAPEAU


%nonassoc FUN, TO, LET, IN, CALL_CC, THROW
%right SEMI
%nonassoc IF, THEN, ELSE
%right SET,EQUAL,LESS
%left PLUS, MINUS, COLONCOLON
%left TIMES, DIV,REM, CHAPEAU
%nonassoc PREFIX
%left LPAR, RPAR
%nonassoc POINT

%start program
%type <Mltype.t_expr> program
%type <Mltype.t_expr> exp
%type <Mltype.t_expr> simple_exp
%type <Mltype.t_expr list> simple_exp_list
%type <Mltype.t_expr list> simple_exp_coma_list

%%

program:
exp                         {$1}

exp:
  | simple_exp              { $1 }
  | simple_exp simple_exp_list { List.fold_left (fun x y -> App(x,y)) $1 (List.rev $2) }  

| exp PLUS exp              { Plus($1,$3) }
| exp MINUS exp             { Moins($1,$3) }
| exp TIMES exp             { Fois($1,$3) }
| exp DIV exp               { Divise($1,$3) }
| exp REM exp               { Reste($1,$3) }
| exp EQUAL exp             { Egal($1,$3) }
| exp LESS exp              { Inferieur($1,$3) }
| exp CHAPEAU exp           { Concat($1, $3) } 
| MINUS exp    %prec PREFIX { Oppose($2) } 

| FUN VAR TO exp            {Lambda($2,$4)}
| LET VAR EQUAL exp IN exp  {Let($2,$4,$6)}
| LET REC VAR EQUAL exp IN exp    {LetRec($3,$5, $7)}
| IF exp THEN exp ELSE exp  { Si($2,$4,$6)}
;

simple_exp : 
| LCR RCR                   { Empty }
| LCR simple_exp_coma_list RCR { List.fold_left (fun x y -> Cons(x,y)) Empty (List.rev $2) }
| simple_exp COLONCOLON simple_exp { Cons ($1, $3) }

| CALL_CC                   { Call_cc }

| INT                       { Const (Entier ($1))}
| FLOAT                     { Const (Float ($1))}
| STRING                    { Const (String ($1))}
| VAR                       { Variable $1}
| TRUE                      { Const (Booleen true)}
| FALSE                     { Const (Booleen false)}
| LPAR exp RPAR             {$2}
;

simple_exp_coma_list:
| simple_exp                { [$1] }
| simple_exp_coma_list SEMI simple_exp { $3 :: $1 }
;

simple_exp_list :
    simple_exp
      { [$1] }
  | simple_exp_list simple_exp
      { $2 :: $1 }
%%

            

