open Array;;
open Printf;;


(* Creation d'un type evitant des erreurs de typages pour le cas ou le
   glouton est meilleur a un point donne de l'arbre *)

type resultat = Cut | Chemin of float * int list;;


(***** L'algorithme de recherche pour le tsp *****)

let rec coupure_search g depart actuel deja_vu borne =
  let cout_min =  ref borne and parcours_min = ref [] and trouve = ref
    false and  teste = ref false in
  deja_vu.(actuel) <- 1;

  for i = 0 to (Array.length g) -1 do
    if deja_vu.(i) = 0 then
      begin
	teste := true;
	if !cout_min >= g.(actuel).(i) then
	  let res = coupure_search g depart i deja_vu (!cout_min -. g.(actuel).(i)) in
	  match res with
	      Chemin (cout,parcours) when cout +. g.(actuel).(i) <=
		!cout_min -> cout_min := g.(actuel).(i) +. cout;
		  parcours_min := i::parcours;
		  trouve := true;
	    |_ -> ()
      end;
  done;
  deja_vu.(actuel) <- 0;
  match (!trouve, !teste) with
      true, _ -> (Chemin (!cout_min,!parcours_min))
    |false, true -> Cut
    |false, false -> Chemin (g.(actuel).(depart), [depart]);;

(********** Le voyageur proprement dit avec coupure **********)

let tsp_coupure g =
  let a= make (Array.length g) 0 in
  let glouton = GreedyApprox.greedy_approx g in
  let tmp = coupure_search g 0 0 a (fst glouton) in
  match tmp with
      Cut -> glouton
    |Chemin (cout,parcours) -> cout, 0::parcours;;