(******************* Determination du "support" commun  deux cycles ***********************)

let rec aretes_communes l1 = function
  [] -> []
| (a,b)::suite when (List.mem (a,b) l1) || (List.mem (b,a) l1) -> (a,b) :: (aretes_communes l1 suite)
| _::suite -> aretes_communes l1 suite;;


(********* formation des tronons communs ****************)

let rec match_droite x = function
  [] -> [], []
| l::suite when List.hd (List.rev l) = x -> l, suite
| l::suite -> match (match_droite x suite) with
                 matching, not_matching -> matching, l::not_matching;;

let rec match_gauche x = function
  [] -> [],[]
| (a::suite2)::suite when a = x -> (a::suite2), suite
| l::suite -> match (match_gauche x suite) with
                 matching, not_matching -> matching, l::not_matching;;

let rec intersection l1 = function
  [] -> []
| x::suite when List.mem x l1 -> x :: (intersection l1 suite)  
| _::suite -> intersection l1 suite;;  

let ajout = fun (a,b) support ->
   match match_droite a support, match_gauche b support, match_droite b support, match_gauche a support with
    ([],_),([],_),([],_),([],_)               -> (a::b::[])::support
  | (l,restant),([], _),([],_),([],_)         -> (l@[b])::restant
  | ([], _),(l,restant),([],_),([],_)         -> (a::l)::restant
  | ([],_),([],_),([], _),(l,restant)         -> (b::l)::restant 
  | ([],_),([],_),(l,restant), ([], _)        -> (l@[a])::restant
  | (l1,restant1),(l2,restant2),([],_),([],_) -> (l1@l2)::(intersection restant1 restant2)
  | ([],_),([],_),(l1,restant1),(l2,restant2) -> (l1@l2)::(intersection restant1 restant2)
  | ([],_),(l1,restant1),([],_),(l2,restant2) -> ((List.rev l2) @ l1)::(intersection restant1 restant2)
  | (l1,restant1),([],_),(l2,restant2),([],_) -> (l1 @ (List.rev l2))::(intersection restant1 restant2)
  | _,_,_,_                                   -> failwith "fusion/ajout : ce cas n'est pas prvu";;

let rec fusionne_ resultat = function
  [] -> resultat
| (a,b)::suite -> fusionne_ (ajout (a,b) resultat) suite;;

let fusionne l1 l2 = 
  fusionne_ [] (aretes_communes l1 l2);;

let rec nbr_aretes_communes = function
  [] -> 0
| x::suite -> (List.length x) - 1 + (nbr_aretes_communes suite);; 

(*************************** Procdures de construction d'un trajet rsultant *******************************)


(******************* fusion heuristique inspire de "crossing-over" dans les algo gntiques **********)

let rec crossing p1 p2 current_running = 
  match p1, p2, current_running with
    [], [], _ -> []
  | [], _ , _ -> failwith "parcours 2 trop long !"
  | _, [] , _ -> failwith "parcours 1 trop long !"
  | a::l1, b::l2, _ when a=b -> a :: (crossing l1 l2 0)
  | a::l1, l, r when (r=0 && Random.bool ()) || r = 1 -> a :: (crossing l1 (List.tl (Trajet.swap_with_first a l)) 1)
  | l, b::l2, _ -> b :: (crossing ( List.tl (Trajet.swap_with_first b l) ) l2 2);;
  
(* il y a un "petit" bug dans crossing et crossing2. Non identifi [pas sr, visiblement, c'est un problme de tarjet[1] *)


let rec crossing2 p1 p2 current_running = 
  match p1, p2, current_running with
    [], [], _ -> []
  | [], _ , _ -> failwith "parcours 2 trop long !"
  | _, [] , _ -> failwith "parcours 1 trop long !"
  | a::l1, b::l2,_ when a=b -> a :: (crossing2 l1 l2 0)
  | a::l1, l, r when (r=0 &&Random.bool ()) || r=1 -> a :: (crossing2 l1 (List.tl (Trajet.connect_with_first a l)) 1)
  | l, b::l2, _ -> b :: (crossing2 ( List.tl (Trajet.connect_with_first b l) ) l2 2);;
  
(************ fusion dterministe : amliore p1 avec p2 **********************)

let transformation_cross i j p =
  for k = 0 to (j-i)/2 do
      let tmp = p.(i+k) in
        p.(i+k) <- p.(j-k);
        p.(j-k) <- tmp;
    done;

exception Trouve of int;;

let trouve_element_tab e p = 
  try for i = 0 to (Array.length p) - 1 do
       if p.(i) = e then raise (Trouve i)
      done;
      failwith "not found (in  trouve_element_tab)";
  with
    Trouve i -> i;;

let crossing3 g p1 p2 = 
  let n = List.length p1 in
  let a = ref (Array.of_list p1) and b = Array.of_list p2 in
  
  let backup = ref (Array.copy !a) in 

  for i = 0 to n-1 do
    
    if !a.(i) = b.(i) then
     (
      if i != 0 then
        if (Trajet.longueur g (Array.to_list !a)) < (Trajet.longueur g (Array.to_list !backup)) then 
          backup := Array.copy !a
        else
          a := Array.copy !backup
     )   
    else    
      transformation_cross i (trouve_element_tab b.(i) !a) !a;
  done;
  
Array.to_list (
   if (Trajet.longueur g (Array.to_list !a)) > (Trajet.longueur g (Array.to_list !backup)) then !a else !backup
 );;  

(*********** meilleure version ******************)

let rec agence p1 p2 = function
  [] -> p1,p2
| a::[] -> p1, p2  
| a::b::suite -> let p1_prime = Trajet.rotate_until_convention a p1 and p2_prime = Trajet.rotate_until_convention a p2 in
  (
    match p1_prime, p2_prime with
      x1::y1::suite1, x2::y2::suite2 when y1=y2 -> p1_prime, p2_prime
    | x1::y1::suite1, x2::y2::suite2 when y1=b  -> p1_prime, (List.rev p2_prime)
    | x1::y1::suite1, x2::y2::suite2            -> (List.rev p1_prime), p2_prime
    | _,_                                       -> failwith "fusion/agence : ce cas n'est pas prvu"
  );;    
  
let rec super_crossing_ g p1 p2 = function
  [] -> p1
| x::suite -> 
    match (agence p1 p2 x) with
      p1_, p2_ -> super_crossing_ g (crossing3 g p1_ p2_) p2 suite;;
  
let sort_by_size_of_list l = List.sort (fun l1 l2 -> Pervasives.compare (List.length l1) (List.length l2)) l;;
  
let super_crossing g p1 p2 =
   let l = sort_by_size_of_list (fusionne (Trajet.to_aretes p1) (Trajet.to_aretes p2)) in
      if l = [] then Printf.printf "crossing sans points communs !\n";
      super_crossing_ g p1 p2 l;; 

(* non tri          11.8569 *)
(* tri croissant    11.8487 *)
(* tri dcroissant  11.8464 *)