let nom = ref "dessin.ps" ;;
let out = ref ( open_out !nom ) ;;
close_out !out ;;

let lwtrait = ref 1 ;;
let police = ref "/CMR10" ;;
let taille = ref 12 ;;
let couleur = ref 0 ;;

let ps_file s =
   if s <> "" then
     nom := s;;

let size_x () = 400;;
let size_y () = 400;;

let header ( ) =              
  let w , h = string_of_int ( size_x () ) , string_of_int ( size_y () ) in
    output_string !out "%!PS-Adobe-3.0\n" ;
    output_string !out ("%%BoundingBox 0 0 " ^ w ^ " " ^ h ^ "\n") ;
    output_string !out "%%EndComments\n\n\n" ;
    output_string !out "newpath 0 0 moveto\n" ;
    output_string !out ( w ^ " 0 lineto\n" ) ;
    output_string !out ( w ^ " " ^ h ^ " lineto\n" ) ;
    output_string !out ( "0 " ^ h ^ " lineto\n" ) ;
    output_string !out ( "0 0 lineto closepath clip\n" )
;;

let open_graph s =
  Graphics.open_graph s ;
  out := open_out !nom ;
  header ( )
;;

let close_graph () =
  output_string !out "showpage\n\n" ;
  output_string !out "%%EOF\n" ;
  close_out !out ;
  Graphics.close_graph ( )
;;

let clear_graph ( ) =
  close_out !out ;
  out := open_out !nom ;
  header ( ) ;
  Graphics.clear_graph ( )
;;

let set_color c =
  let r , g , b = ( c lsr 16 ) land 0xFF,
                  ( c lsr 8 ) land 0xFF ,
                  c land 0xFF in
    let d = float_of_int 255 in
      output_string !out ( string_of_float ( float_of_int r /. d ) ^
                           " " ^
                           string_of_float ( float_of_int g /. d ) ^
                           " " ^
                           string_of_float ( float_of_int b /. d ) ^
                           " setrgbcolor\n" ) ;
      Graphics.set_color c
;;

let plot x y =
  output_string !out ( "newpath " ^
                        string_of_int x ^ " " ^
                        string_of_int y ^ " " ^
                        " 1 0 360 arc closepath stroke\n" ) ;
  Graphics.plot x y;;

let draw_segments a = 
let draw_segment x0 y0 x y =
     output_string !out ( "newpath  " ^
                         string_of_int x0 ^
                         " " ^
                         string_of_int y0 ^
                         " moveto\n" ) ;
    output_string !out ( string_of_int x ^
                         " " ^
                         string_of_int y ^
                         " lineto closepath stroke\n" ) ;
    
in
  let rec tmp = function
    [] -> ()
  | (x0,y0, x,y)::suite -> draw_segment x0 y0 x y; tmp suite
in
  tmp (Array.to_list a);
  Graphics.draw_segments a;;

let fill_rectangle x1 y1 x2 y2 = 
  output_string !out ( "newpath  " ^ string_of_int x1 ^ " " ^ string_of_int y1 ^ " moveto\n" ) ;
  output_string !out ( string_of_int x2 ^ " " ^ string_of_int y1 ^ " lineto\n" ) ;
  output_string !out ( string_of_int x2 ^ " " ^ string_of_int y2 ^ " lineto\n" ) ;
  output_string !out ( string_of_int x1 ^ " " ^ string_of_int y2 ^ " lineto\n" ) ;
  output_string !out ( string_of_int x1 ^ " " ^ string_of_int y1 ^ " lineto closepath fill\n" ) ;;


let draw_circle x y r =
  output_string !out ( "newpath " ^
                       string_of_int x ^ " " ^
                       string_of_int y ^ " " ^
                       string_of_int r ^
                       " 0 360 arc closepath stroke\n" ) ;
  Graphics.draw_circle x y r
;;


let draw_string x0 y0 s =
     output_string !out ( !police ^
                         " findfont " ^
                         string_of_int !taille ^
                         " scalefont setfont\n" ) ;
    output_string !out ( string_of_int x0 ^
                         " " ^
                         string_of_int y0 ^
                         " moveto\n" ) ;
    output_string !out ( "(" ^ s ^ ") show\n" ) ;
    Graphics.draw_string s
;;

let set_font s =
  police := "/" ^ s ;
  Graphics.set_font s
;;

let set_text_size n =
  taille := n ;
  Graphics.set_text_size n
;;

let fill_circle x y r =
  output_string !out ( "newpath " ^
                       string_of_int x ^ " " ^
                       string_of_int y ^ " " ^
                       string_of_int r ^
                       " 0 360 arc closepath fill\n" ) ;
  Graphics.fill_circle x y r
;;